///
// Copyright (C) 2002, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include "psstream.hh"

#include <algorithm>		// max?
#include <iomanip>		// ?!?!?
#include <unistd.h> // unlink
#include <cstdlib> // getenv, mkstemp
#include <cstring> // strdup
#include <stdexcept>

namespace xml2ps {
PsStream::PsStream(std::streambuf *buf,
		   const int& out_width, const int& out_height)
  : std::ostream(buf), page_no_(0), 
  width_max(out_width), height_max(out_height)
{
  // Create a tmp file
  // Todo: share code with pptout
  // Duplication of effort
  using std::string;
  string tmplate="xml2psXXXXXX";
  if(char* tmpdir = getenv("TMPDIR")) {
    tmplate = string(tmpdir) + '/' + tmplate;
  } else {
    tmplate = "/tmp/" + tmplate;
  }
  char *templ=strdup(tmplate.c_str());
  int fd=mkstemp(templ);
  tmp_filename=string(templ);
  delete templ;
  if(fd==-1)
    throw std::runtime_error("Could not open temp file " 
			     + tmp_filename);
  // Todo: This is bad!
  close(fd);
  tmp.open(tmp_filename.c_str(), std::ios::in|std::ios::out);
}

PsStream::~PsStream() {
  using std::endl;
  tmp << endl << "showpage" << endl
      << "grestore" << endl << endl
      << "%%Trailer" << endl
      << "%%EOF" << endl;

  // write head:
  dynamic_cast<std::ostream&>(*this)
    << "%!PS-Adobe-3.0" << endl
    << "%%Creator: xml2ps by rasmus@kaj.se" << endl
    << "%%LanguageLevel: 2" << endl
    << "%%Pages: " << std::dec << page_no_ << endl
    << "%%BoundingBox: 0 0 " 
    << width_max << ' ' << height_max << endl;

  // Todo: split font comments into several lines, if necessary.
  if(!require_fonts.empty())
    {
        dynamic_cast<std::ostream&>(*this) 
	  << "%%DocumentNeededResources: font";
      for(FontSet::const_iterator i=require_fonts.begin();
	  i!=require_fonts.end();
	  i++)
        dynamic_cast<std::ostream&>(*this) 
	  << ' ' << i->c_str();
      dynamic_cast<std::ostream&>(*this) 
	<< endl;
    }
  if(!include_fonts.empty())
    {
      dynamic_cast<std::ostream&>(*this) 
	<< "%%DocumentSuppliedResources: font";
      for(FontSet::const_iterator i=include_fonts.begin();
	  i!=include_fonts.end();
	  i++)
	dynamic_cast<std::ostream&>(*this) 
	  << ' ' << i->c_str();
      dynamic_cast<std::ostream&>(*this) 
	<< endl;
    }
  dynamic_cast<std::ostream&>(*this) 
    << "%%EndComments" << endl
    << "%%BeginProlog" << endl
    << endl
    << "/S { show } bind def" << endl
    << "/M { moveto } bind def" << endl
    << "/WS { 0 rmoveto } bind def" << endl
    << "/F { findfont exch scalefont setfont } bind def" << endl
    << "/UFROM { currentpoint 3 -1 roll add } bind def" << endl
    << "/UTO { 4 2 roll currentpoint 2 copy 6 4 roll moveto" << endl
    << "   5 -1 roll add lineto 3 -1 roll setlinewidth stroke moveto"
    << "} bind def" << endl
    << endl
    << "/Latin1Encode { dup findfont dup length dict begin" << endl
    << "  { 1 index /FID ne {def} {pop pop} ifelse } forall" << endl
    << "  /Encoding ISOLatin1Encoding def" << endl
    << "  currentdict definefont pop end" << endl
    << "} bind def" << endl
    << "%%EndProlog" << endl
    << "%%BeginSetup" << endl;
  
   // Todo: not all fonts should have a iso-8859-1 encoding:
   // Todo: respect include_fonts
  for(FontSet::const_iterator i=require_fonts.begin();
      i!=require_fonts.end();
      i++)
    dynamic_cast<std::ostream&>(*this) 
      << "%%IncludeResource: font " << i->c_str() << endl
      << '/' << i->c_str() << " Latin1Encode" << endl;

  dynamic_cast<std::ostream&>(*this) 
    << "0 setlinewidth" << endl
    << "%%EndSetup" << endl
    << endl;

  // copy the tmp file to (*this)
  tmp.seekg(0);
  std::string line;
  while(!getline(tmp, line).eof()) 
    dynamic_cast<std::ostream&>(*this) 
      << line.c_str() << endl;
  
  //close and delete tmp file
  tmp.close();
  if(unlink(tmp_filename.c_str()) != 0)
    std::cerr << "Failed to delete " << tmp_filename << endl;
}

void
PsStream::closePage() {
  using std::endl;
  if(page_no_)
    tmp << endl << "showpage" << endl
	<< "grestore" << endl;
}

void
PsStream::newPage() {
  using std::endl;
  ++page_no_;
  tmp << endl
      << "%%Page: \"" << std::dec << page_no_ << "\" " << page_no_ << endl
      << "gsave" << endl;
}

void
PsStream::newPage(const int& width, const int& height) {
  newPage();
  tmp << "%%PageBoundingBox: 0 0 " << width << ' ' << height << std::endl;
  width_max=std::max(width_max, width); 
  height_max=std::max(height_max, height);
}

void 
PsStream::require_font(const std::string &fontname)
{
  require_fonts.insert(fontname);
}

void 
PsStream::include_font(const std::string &fontname) // can't include yet
{
  include_fonts.insert(fontname);
}
}
