///
// Copyright (C) 2002, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#ifndef X2P_PSSTR
#define X2P_PSSTR
#include <string>
#include <iostream>
#include <fstream>
#include <set>
#include "fontinfo.hh"

namespace xml2ps {
class PsStream : public std::ostream {
public:
  explicit PsStream(std::streambuf *buf, 
		    const int& out_width = 0,
		    const int& out_height = 0);
  ~PsStream();

  void closePage();
  void newPage();
  void newPage(const int& width, const int& height);

  void require_font(const std::string &fontname);
  void include_font(const std::string &fontname); // can't include yet

  template<class A> 
  std::ostream& operator<<(A a)
  {return tmp << a;} 

private:
  
  typedef std::set<std::string> FontSet;
  FontSet require_fonts, include_fonts;
  int page_no_, width_max, height_max;
  std::fstream tmp;
  std::string tmp_filename;
};
};

#endif
