<?xml version='1.0' encoding="iso-8859-1"?>
<!-- A very basic xhtml-to-xml2ps stylesheet. 
     Tables, images and much more are not supported. 
     Fredrik Arnerup, 18 Nov 2002 -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:xhtml="http://www.w3.org/1999/xhtml"> 
  <xsl:output method="xml" indent="yes" encoding="iso-8859-1"/>

  <xsl:variable name="lcletters">abcdefghijklmnopqrstuvwxyz</xsl:variable>
  <xsl:variable name="ucletters">ABCDEFGHIJKLMNOPQRSTUVWXYYZ</xsl:variable>

  <xsl:template match="xhtml:html|xhtml:div">
    <block-container font-family="Times-Roman" font-size="10pt">
      <xsl:apply-templates/>
    </block-container>
  </xsl:template>

  <!-- Ignore head -->
  <xsl:template match="xhtml:head">
  </xsl:template>

  <xsl:template match="xhtml:h1">
    <para align="left" font-family="Helvetica-Narrow-Bold" span-columns="1"
          font-size="36pt" margin-bottom="20pt">
      <xsl:apply-templates/>
    </para>
  </xsl:template>

  <xsl:template match="xhtml:h2">
    <para align="left" margin-top="14pt"
          font-family="Helvetica-Bold" font-size="14pt">
      <xsl:apply-templates/>
    </para>
  </xsl:template>

  <xsl:template match="xhtml:h3|xhtml:h4|xhtml:h5|xhtml:h6">
    <para align="left" margin-top="12pt"
          font-family="Helvetica-Bold" font-size="12pt">
      <xsl:apply-templates/>
    </para>
  </xsl:template>

  <xsl:template match="xhtml:p">
    <para align="justify" line-height="1.4">
      <xsl:apply-templates/>
    </para>
  </xsl:template>

<!-- Unordered lists -->
  <xsl:template match="xhtml:ul">
     <block-container font-family="Times-Roman" font-size="10"
                      margin-left="10pt"> 
       <xsl:apply-templates/>
     </block-container>
  </xsl:template>

  <xsl:template match="xhtml:li">
    <para align="left" line-height="1.4">*&#160;<xsl:apply-templates/></para>
  </xsl:template>

<!-- Ordered lists -->
  <xsl:template match="xhtml:ol">
     <block-container font-family="Times-Roman" font-size="10" margin-left="10pt">
       <xsl:apply-templates/>
     </block-container>
  </xsl:template>

  <xsl:template match="xhtml:ol/xhtml:li">
    <para align="left" line-height="1.4"><xsl:number/>.&#160;<xsl:apply-templates/></para>
  </xsl:template>

<!-- Definition lists -->
  <xsl:template match="xhtml:dl">
     <block-container font-family="Times-Roman" font-size="10">
       <xsl:apply-templates/>
     </block-container>
  </xsl:template>

  <xsl:template match="xhtml:dl/xhtml:dt">
    <para align="left" line-height="1.4"><xsl:apply-templates/></para>
  </xsl:template>

  <xsl:template match="xhtml:dl/xhtml:dd">
    <para align="left" line-height="1.4"><leader width="1em"/><xsl:apply-templates/></para>
  </xsl:template>

<!-- Can't have <para> within <para> -->
  <xsl:template match="xhtml:dt//xhtml:dt
                       |xhtml:dt//xhtml:dd
                       |xhtml:dt//xhtml:li
		       |xhtml:dt//xhtml:p
		       |xhtml:dd//xhtml:dt
                       |xhtml:dd//xhtml:dd
                       |xhtml:dd//xhtml:li
		       |xhtml:dd//xhtml:p
		       |xhtml:li//xhtml:dt
                       |xhtml:li//xhtml:dd
                       |xhtml:li//xhtml:li
		       |xhtml:li//xhtml:p
		       |xhtml:p//xhtml:dt
                       |xhtml:p//xhtml:dd
                       |xhtml:p//xhtml:li
		       |xhtml:p//xhtml:p
">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="xhtml:a">
    <font underline="1"><xsl:apply-templates/></font>
  </xsl:template>
  
  <xsl:template match="xhtml:em|xhtml:i|xhtml:var">
    <font font-family="Times-Italic"><xsl:apply-templates/></font>
  </xsl:template>

  <xsl:template match="xhtml:b|xhtml:strong">
    <font font-family="Times-Bold"><xsl:apply-templates/></font>
  </xsl:template>

  <xsl:template match="xhtml:b/xhtml:em|xhtml:b/xhtml:i|xhtml:strong/xhtml:em|xhtml:strong/xhtml:i|xhtml:em/xhtml:b|xhtml:em/xhtml:strong|xhtml:i/xhtml:b|xhtml:i/xhtml:strong">
    <font font-family="Times-BoldItalic"><xsl:apply-templates/></font>
  </xsl:template>

  <xsl:template match="xhtml:tt|xhtml:code">
    <font font-family="Courier"><xsl:apply-templates/></font>
  </xsl:template>

  <xsl:template match="xhtml:acronym">
    <font font-family="Times-Bold" font-size="66.667%" letter-spacing="0.2em">
      <xsl:value-of select="translate(substring(., 1),$lcletters,$ucletters)"/>
    </font>
  </xsl:template>

  <xsl:template match="xhtml:small">
    <font font-size="66%"><xsl:apply-templates/></font>
  </xsl:template>

  <xsl:template match="xhtml:big">
    <font font-size="150%"><xsl:apply-templates/></font>
  </xsl:template>

  <xsl:template match="xhtml:sub">
    <font font-size="66%" baseline="-0.3em"><xsl:apply-templates/></font>
  </xsl:template>

  <xsl:template match="xhtml:sup">
    <font font-size="66%" baseline="0.5em"><xsl:apply-templates/></font>
  </xsl:template>

  <xsl:template match="xhtml:q|xhtml:cite">
    "<xsl:apply-templates/>"
  </xsl:template>
  
  <xsl:template match="*">
    <xsl:apply-templates/>
  </xsl:template>

</xsl:stylesheet>








