///
// Copyright (C) 2002, 2003, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include "aboutdialog.h"
#include "safeslot.h"
#include "globals.h"		// version and builddate
#include "widget/wmisc.h"
#include <gtkmm/label.h>
#include <gtkmm/image.h>
#include <gtkmm/box.h>
#include <gtkmm/stock.h>
#include "icons/logo.h"
#include "processman.h"
#include "webbrowser.h"

namespace {
  const int OPEN_WEBPAGE = 4711;
}

About_Dialog::About_Dialog() :
  DialogWrap("About Passepartout")
{
  set_resizable(false);

  Gtk::Box *hbox = manage(new Gtk::HBox(false, double_space));
  hbox->set_border_width(double_space);

  Gtk::Image *image = 
    manage(new Gtk::Image(Gdk::Pixbuf::create_from_inline(69624, logo)));
  hbox->pack_start(*image, Gtk::PACK_SHRINK);

  Gtk::Box *message = manage(new Gtk::VBox());
  hbox->pack_start(*message, Gtk::PACK_SHRINK);

  Gtk::Label *label =
    manage(new Gtk::Label("", Gtk::JUSTIFY_LEFT, Gtk::ALIGN_BOTTOM));
  label->set_markup("<big><b>Passepartout " + version + "</b></big>"
		      "\nCopyright &#169; 2002, 2003,"
		      " Fredrik Arnerup &amp; Rasmus Kaj");
  label->set_selectable();
  message->pack_start(*label);

  label =
    manage(new Gtk::Label("", Gtk::JUSTIFY_LEFT, Gtk::ALIGN_TOP));
  label->set_markup("<u><span foreground=\"blue\">" + homepage + "</span></u>");
  Gtk::Button *webpage = 
    manage(new Gtk::Button());
  webpage->add(*label);
  webpage->set_relief(Gtk::RELIEF_NONE);
  webpage->set_border_width(0);
  webpage->signal_clicked().connect
    (bind(slot(*this, &About_Dialog::on_response), OPEN_WEBPAGE));
  webpage->signal_activate().connect
    (bind(slot(*this, &About_Dialog::on_response), OPEN_WEBPAGE));
  message->pack_start(*webpage, Gtk::PACK_SHRINK);

  label =
    manage(new Gtk::Label("", Gtk::JUSTIFY_LEFT, Gtk::ALIGN_BOTTOM));
  label->set_markup("\nBuild date: " + std::string(builddate));
  label->set_selectable();
  message->pack_start(*label, Gtk::PACK_SHRINK);

  add_button(Gtk::Stock::CLOSE, Gtk::RESPONSE_CLOSE)->grab_focus();

  get_vbox()->pack_start(*hbox);
  show_all_children();
}

void About_Dialog::on_response(int response_id) {
  switch(response_id) {
  case OPEN_WEBPAGE:
    open_homepage();
    break;
  case Gtk::RESPONSE_CLOSE:
      hide();
    break;
  default: 
    break;
  }
}
