#ifndef BASICFRAME_H		// -*- c++ -*-
#define BASICFRAME_H
///
// Copyright (C) 2002, 2003, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include "pagent.h"
#include "fileerrors.h"
#include <iostream>
#include <libxml++/libxml++.h>

namespace Error {
  struct Frame_Type: public File {
    Frame_Type(const string& msg) : File("Frame-type error: " + msg) {}
  };
}

class Basic_Frame: public Pagent {
public:
  Basic_Frame(Group *parent, float w, float h, const Glib::ustring& name);
  Basic_Frame(Group *parent, const xmlpp::Element& node);
  virtual ~Basic_Frame();
  
  virtual xmlpp::Element *save(xmlpp::Element& parent_node) const;
  virtual void print(std::ostream &out, bool grayscale = false) const;
  
  Boundary get_box() const;
  Boundary get_obstacle_boundary() const;
  
  // Errors reported by generate_picture:
  // ASSOCIATION - failed to open associated file
  //  GENERATION - general error (missing program, corrupted file, et cetera)
  //    ZEROSIZE - picture has zero size
  enum Gen_Pic_Error_Type { ASSOCIATION, GENERATION, ZEROSIZE }; 
  struct Gen_Pic_Error : public std::logic_error {
    Gen_Pic_Error_Type type;
    Gen_Pic_Error(Gen_Pic_Error_Type t, std::string s)
      : logic_error(s), type(t) {}
    ~Gen_Pic_Error() throw() {}
  };
  
  void draw_content_error(View& view, Glib::RefPtr<const Gdk::Pixmap> pixmap);
  void draw_content_wait(View& view);
  void draw_content_missing(View& view);
  void draw_content_broken(View& view);
};

#endif
