#ifndef CACHEDFRAME_H		// -*- c++ -*-
#define CACHEDFRAME_H
///
// Copyright (C) 2002, 2003, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include "basicframe.h"
#include <gdkmm.h>
#include <sys/types.h>

class Cached_Frame: public Basic_Frame {
public:
  Cached_Frame(Group *parent, float w, float h,
	       const Glib::ustring &name);
  Cached_Frame(Group *parent, const xmlpp::Element& node);
  virtual ~Cached_Frame();

  void clear_picture();
  void clear_cache() { clear_picture(); }

  virtual void act_on_zoom_factor_change();

protected:
  bool no_picture_generated; 
  // true if no cached file has been generated when process_stopped is called

  bool white_is_transparent; // fake transparency

  virtual void generate_picture(View& view) = 0;
  bool draw_content(View& view, bool reshaping = false);
  void process_stopped(pid_t _pid, bool exited_normally, int exit_code);
  
  Glib::RefPtr<Gdk::Pixbuf> picture; // alpha channel included
  std::string tmp_file;
  pid_t pid;
  SigC::Connection proc_stop_connection;
};

#endif



