#ifndef CONFIG_H		// -*- c++ -*-
#define CONFIG_H
///
// Copyright (C) 2002, 2003, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include "util/configfile.h"
#include <sigc++/object.h>
#include <gtkmm/dialog.h>


struct Gui_Var {
  std::string desc; // description
  bool visible; // display in gui
  Gui_Var(std::string desc_): desc(desc_), visible(true) {}
};

struct B_Var: public Config::Bool_Var, public Gui_Var {
  B_Var(std::string name_, std::string desc_): 
    Bool_Var(name_), Gui_Var(desc_) {}
};

struct S_Var: public Config::String_Var, public Gui_Var {
  S_Var(std::string name_, std::string desc_): 
    String_Var(name_), Gui_Var(desc_) {}
};

struct F_Var: public Config::Float_Var, public Gui_Var {
  F_Var(std::string name_, std::string desc_): 
    Float_Var(name_), Gui_Var(desc_) {}
};

class P_File: public Config::File, public SigC::Object {
public:
  F_Var ReshapeBoxSize, ScreenResolution, DefaultResolution;
  B_Var Landscape, FakeTransparency;
  S_Var PaperName, PrintCommand, FontPath, StylesheetPath,
    PSInterpreter, PSViewer;
  //  S_Var fonts_to_include;
  P_File();
  ~P_File();
  void read();
  Gtk::Dialog &get_dialog();
  void dialog_show();
protected:
  void dialog_ok();
  void dialog_cancel();
  bool dialog_delete(GdkEventAny*);

  void error(const std::string &message);
  Gtk::Dialog *dialog;
  bool first_error;
  std::string user_file, global_file;
};

#endif
