///
// Copyright (C) 2002, 2003, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include "errordialog.h"
#include "globals.h"
#include <util/warning.h>
#include <string>

Error_Dialog* Error_Dialog::dialog = 0;

void Error_Dialog::init(Gtk::Window& parent) {
  if(!dialog)
    dialog = new Error_Dialog(parent);
}

void Error_Dialog::view(const std::string& message) {
  if(dialog)
    dialog->show_message(message);
  else {
    const std::string line(" - - - - - - - - - - - - - - - - - - - - - - - ");
    warning << "\n" << line
	    << "\n\t" << "Error:" << "\n\t" << message
	    << "\n" << line << "\n";
  }
}

Error_Dialog::Error_Dialog(Gtk::Window &parent)
  :MessageDialog(parent, "", Gtk::MESSAGE_ERROR,
		 Gtk::BUTTONS_OK, true, false)
		 
{
  if(get_action_area()){
    Gtk::Button *ok_button = 
      dynamic_cast<Gtk::Button*>
      (get_action_area()->children().front().get_widget());
    if(ok_button)
      ok_button->signal_clicked().connect(slot(*this, &Error_Dialog::hide));
  }
}

void Error_Dialog::show_message(const std::string& message) {
  set_message(message);
  show_all();
}
