///
// Copyright (C) 2002, 2003, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include "filewatcher.h"
#include "safeslot.h"
#include <sys/stat.h>

File_Watcher::File_Watcher() {
  // Todo:  Lower priority?  Longer interval?
  connection = Glib::signal_timeout().connect
    (safeslot(*this, &File_Watcher::check_file), 100);
}

File_Watcher::~File_Watcher() {
  connection.disconnect();
}

bool File_Watcher::check_file() {
  const std::string filename = file_to_watch();

  // don't say the file is modified on the first stat(2)
  bool new_name = false;
  if(last_file != filename) {
    last_file = filename;
    new_name = true;
  }

  if(filename == "")
    return true;

  struct stat buf;
  if(stat(filename.c_str(), &buf) == 0) {
    if(buf.st_mtime != last_time) {
      last_time = buf.st_mtime;
      if(!new_name)
	file_modified();
    }
  }

  return true;
}
