#ifndef FILEWATCHER_H		// -*- c++ -*-
#define FILEWATCHER_H
///
// Copyright (C) 2002, 2003, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include <sigc++/sigc++.h>
#include <string>

class File_Watcher: public SigC::Object {
public:
  File_Watcher();
  virtual ~File_Watcher();

protected:
  virtual std::string file_to_watch() const = 0;
  virtual void file_modified() = 0;

private:
  std::string last_file;
  time_t last_time;
  SigC::Connection connection;
  bool check_file();  
};

#endif
