#ifndef GROUP_H			// -*- c++ -*-
#define GROUP_H
///
// Copyright (C) 2002, 2003, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include "pagent.h"
#include <list>

enum Rearrange_Target { UP, DOWN, TOP, BOTTOM };

class Group : public Pagent {
public:
  typedef std::list<Pagent*> ChildVec;
  
  Group(Group *parent, const Glib::ustring& name);
  Group(Group *parent, const Glib::ustring& name, const Matrix& xform);
  virtual ~Group();
  
  xmlpp::Element *save(xmlpp::Element& parent_node) const;
  void print(std::ostream& out, bool grayscale = false) const;
  
  bool draw_content(View& view, bool reshaping = false);
  void clear_cache();

  Boundary get_box() const;
  void set_flow_around(bool);
  bool get_flow_around() const;
  Boundary get_obstacle_boundary() const;
  BoundaryVect Group::obstacle_list() const;
  
  void act_on_zoom_factor_change();

  void add(Pagent* obj);
  Pagent* ungroup(Pagent* obj);
  void rearrange_selected(Rearrange_Target target);
  void group_selected();
  void ungroup_selected();
  int count() const {return childs.size();}
//protected:
  void save_childs(xmlpp::Element& node) const;
  ChildVec::const_iterator pbegin() const { return childs.begin(); }
  ChildVec::const_iterator pend() const { return childs.end(); }
  ChildVec::const_reverse_iterator prbegin() const { return childs.rbegin(); }
  ChildVec::const_reverse_iterator prend() const { return childs.rend(); }

  // A change in a child is a change in the group:
  virtual void child_ready_to_draw(Pagent *pagent);
  virtual void child_props_changed(Pagent *pagent);
  virtual void child_geometry_changed(Pagent *pagent);
private:
  ChildVec childs;
};

#endif
