///
// Copyright (C) 2002, 2003, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include "groupmeta.h"
#include "group.h"
#include "pptcore.h"
#include "fileerrors.h"
#include <util/warning.h>
#include <util/stringutil.h>

Pagent*
GroupMeta::load(const xmlpp::Element& node, Group* parent) {
  Matrix m;
  std::string name = "group";
  if(const xmlpp::Attribute* xform = node.get_attribute("transform"))
    m = to<Matrix>(xform->get_value());
  if(const xmlpp::Attribute* namep = node.get_attribute("name"))
    name = namep->get_value();
  Group* g = new Group(parent, name, m);
  
  // read pagents:  Todo: Avoid duplicate (page.cc:43)
  const xmlpp::Element::NodeList children = node.get_children();
  for(xmlpp::Element::NodeList::const_iterator i=children.begin();
      i!=children.end();
      i++)
    {
      std::string name=(*i)->get_name();
      xmlpp::Element *element=dynamic_cast<xmlpp::Element*>(*i);
      if(name=="frame" && element)
	{
	  const xmlpp::Attribute* type_node = element->get_attribute("type");
	  if(!type_node)
	    throw Error::Read("No type attribute for frame");
	  
	  const std::string type = type_node->get_value();
	  
	  if(MetaBase* loader = core.getMeta(type))
	    g->add(loader->load(*element, g));
	  
	  else
	    throw Error::Read("No appropriate loader for  \"" + type + "\".");
	}
      else
	warning << "Unknown node <" << name
		<< "> ignored in group" << std::endl;
    }
  return g;
}

PropBase* GroupMeta::getProp() { return 0; }
