#ifndef IMAGEFRAME_H		// -*- c++ -*-
#define IMAGEFRAME_H
///
// Copyright (C) 2002, 2003, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include "filewatcher.h"
#include "cachedframe.h"

class Image_Frame: public Cached_Frame, public File_Watcher {
public:
  // try to determine if a file is a ps
  static bool is_postscript(std::string filename);

  Image_Frame(Group *parent, 
	      const Glib::ustring& assoc,
	      float w, float h);
  Image_Frame(Group *parent, const xmlpp::Element& node);
  virtual ~Image_Frame();

  virtual xmlpp::Element *save(xmlpp::Element& parent_node) const ;
  virtual void print(std::ostream &out, bool grayscale = false) const;


 // *** undoable actions ***
  void set_association(const Glib::ustring &s, bool push_undo = false);


  // *** probe state ***
  const Glib::ustring &get_association() const {return association;}

protected:
  Glib::ustring association, parsed_file;
 
  void generate_picture(View& view);
  std::string file_to_watch() const
  {return association;}
  void file_modified();
  void read_size();
};

#endif
