///
// Copyright (C) 2002, 2003, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include <gtkmm/main.h>

#include <fonts/fontinfo.hh>
#include <util/warning.h>
#include <defines.h> // VERSION

#include "globals.h"
#include "window.h"
#include "processman.h"
#include "config.h"
#include "fileerrors.h"
#include "inspiration.h"
#include "icons/icon_48.h"

P_File config;
Process_Manager process_manager("pptout");
std::string version = VERSION;
Inspiration *inspiration;

int main(int argc, char *argv[])
{
  int win_count = 0;

  // initialize threads
  Glib::thread_init();

  // initialise gtkmm
  Gtk::Main kit(argc, argv);
  inspiration = new Inspiration();

  // application icon
  std::vector<Glib::RefPtr<Gdk::Pixbuf> > icon_list;
  icon_list.push_back(Gdk::Pixbuf::create_from_inline(9240, icon_48));
  Gtk::Window::set_default_icon_list(icon_list);

  // parse command line
  for(int i = 1; i < argc; i++) {
    std::string arg(argv[i]);
    if(arg == "-v") { // print version number
      warning << "Passepartout " << version << std::endl;
      return 0;
    } else if(arg == "-V") { // be verbose
      verbose.active = true;
    } else if(arg == "-d") { // be annoyingly verbose
      verbose.active = true;
      debug.active = true;
      debug << "Debug mode active" << std::endl; // Why wait?
    } else if(arg == "-h" 
	      || arg == "--help") { // display command line help
      std::cout << "Usage: pptout [options] [files...]" << std::endl;
      std::cout << "\t-d\tShow debugging messages." << std::endl;
      std::cout << "\t-h, --help\tShow this help message." << std::endl;
      std::cout << "\t-V\tBe verbose." << std::endl;
      std::cout << "\t-v\tShow version number." << std::endl;
      return 0;
    } else { // open file
      try {
	config.read(); // after the cerr aliases are set
	new Frame_Window(arg, 0);
	win_count++;
      } catch(const std::exception& err) {
	warning << "Error opening " << arg
		<< ": " << err.what() << std::endl;
      }
    }
  }

  if(!win_count) { // open empty window
    config.read(); // after the cerr aliases are set
    new Frame_Window();
    win_count++;
  }

  // initialize font paths
  font::FontInfo::FontPaths font_paths;
  for(Config::Strings::const_iterator i = config.FontPath.values.begin();
      i != config.FontPath.values.end();
      i++) {
    font_paths.push_back(*i);
  }
  font::FontInfo::init(&font_paths);
  
  // if no windows were opened, don't run the kit 
  if(win_count) {
    gdk_rgb_init();		// Needed before rendering pixbuf to screen.
    Gtk::Main::run();
  }

  delete inspiration; // looks nice
  return 0;
}





