#ifndef PAGESEL_H		// -*- c++ -*-
#define PAGESEL_H
///
// Copyright (C) 2002, 2003, Fredrik Arnerup & Rasmus Kaj, See COPYING
///

#include "docview.h"
#include "widget/dialogwrap.h"
#include <gtkmm/box.h>
#include <gtkmm/button.h>
#include <gtkmm/optionmenu.h>
#include <gtkmm/menu.h>
#include <gtkmm/treeview.h>
#include <gtkmm/liststore.h>

class Pagesel: public Gtk::HBox {
public:
  Pagesel(Document_View &docview);
  ~Pagesel();

  Gtk::OptionMenu &get_optionmenu() {return pages;}

private:
  Document_View &document_view;
  Gtk::Menu menu;
  Gtk::OptionMenu pages;
  Gtk::Button left, right;
  void next();
  void prev();
  void page_selected_action();
  void update();
};

class Template_Page_Dialog: public DialogWrap {
public:
  Template_Page_Dialog(Gtk::Window &parent, Document_View &document_view_);
  void show_it(bool new_page_ = false, int page_num_ = 0);

private:
  Document_View &document_view;

  Glib::RefPtr<Gtk::ListStore> tree_model;
  Gtk::TreeView page_list;

  bool new_page;
  int page_num;
  void on_response(int response_id);
};

#endif









