///
// Copyright (C) 2002, 2003, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include "paper_sizes.h"
#include "lengthunits.h"

Papers papers;

Papers::Papers() {
  LengthUnits &l = length_units;

  // ISO golden section paper sizes 
  // - used in almost the entire civilised world
  sizes["A0"] = Size(l.to_base(841, "mm"), l.to_base(1189, "mm"));
  sizes["A1"] = Size(l.to_base(594, "mm"), l.to_base(841, "mm"));
  sizes["A2"] = Size(l.to_base(420, "mm"), l.to_base(594, "mm"));
  sizes["A3"] = Size(l.to_base(297, "mm"), l.to_base(420, "mm"));
  sizes["A4"] = Size(l.to_base(210, "mm"), l.to_base(297, "mm"));
  sizes["A5"] = Size(l.to_base(148, "mm"), l.to_base(210, "mm"));
  sizes["A6"] = Size(l.to_base(105, "mm"), l.to_base(148, "mm"));

  // paper sizes used in the U.S. and Canada
  // "Tabloid" and "Ledger" are two names for the same paper
  sizes["Letter"] = Size(l.to_base(216, "mm"), l.to_base(279, "mm"));
  sizes["Legal"] = Size(l.to_base(216, "mm"), l.to_base(356, "mm"));
  sizes["Executive"] = Size(l.to_base(190, "mm"), l.to_base(254, "mm"));
  sizes["Tabloid/Ledger"] = Size(l.to_base(279, "mm"), l.to_base(432, "mm"));
}
