#ifndef PROPERTIESDIALOG_H	// -*- c++ -*-
#define PROPERTIESDIALOG_H
///
// Copyright (C) 2002, 2003, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include "document.h"
#include <widget/dialogwrap.h>
#include <gtkmm/notebook.h>
#include <gtkmm/button.h>
#include <vector>

class PropBase;

/**
 * A dialog displaying properties of the selected objeckt.  It will listen
 * for selection events, so when the user selects a new object, the existing
 * dialog will show properties for that object.
 */
class PropertiesDialog : public DialogWrap {
public:
  PropertiesDialog();
  
  void show_raise();		// Make sure this dialog is visible
  void apply();			// Apply changes done in this dialog
  
  void *get_document() const
  {return document;}
  void set_document(Document *document_);
  
private:
  void select_change(Document* doc);		// signal listener
  void update();
  Document *document;

  Gtk::Notebook book;
  std::vector<PropBase*> pages;
  Gtk::Button apply_button, close_button;
};

#endif
