#ifndef RASTERFRAME_H		// -*- c++ -*-
#define RASTERFRAME_H
///
// Copyright (C) 2002, 2003, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include "filewatcher.h"
#include "basicframe.h"
#include "pixbuftransformator.h"

class Raster_Frame: public Basic_Frame, public File_Watcher {
public:
  Raster_Frame(Group *parent, const xmlpp::Element& node);
  Raster_Frame(Group *parent, const Glib::ustring& filename, float res = -1);
  // negative res means use default
  virtual ~Raster_Frame();

  virtual xmlpp::Element *save(xmlpp::Element& parent_node) const;
  virtual void print(std::ostream &out, bool grayscale = false) const;

  bool draw_content(View& view, bool reshaping = false);
  void clear_cache();

  void act_on_zoom_factor_change();


 // *** undoable actions ***
  void set_association(const Glib::ustring &s, bool push_undo = false);
  // Manage the ppi on paper (not the screen resolution).
  // dpi is printer resolution - ppi is image resolution
  void set_ppi(const Vector& ppi, bool push_undo = false); // scales the image
  void set_size(float w, float h, bool push_undo = false); // overrides Pagent

  // *** probe state ***
  const Glib::ustring &get_association() const {return association;}
  Vector get_ppi();
  Vector get_default_ppi();


  // *** non-undoable actions ***
  void set_default_ppi()
  {set_ppi(get_default_ppi());}
  
private:
  Glib::ustring association;
  
  Gdk::Point unit_size;		// Number of pixels in image
  Glib::RefPtr<Gdk::Pixbuf> filepixbuf, screenpixbuf;
  PixbufTransformator* worker;
  
  void _set_ppi(const Vector& ppi); 
  // same as above, but don't emit signals and dont clear screenpixbuf

  void load_unit_size();
  std::string file_to_watch() const {return association;}
  void file_modified();
};

#endif



