///
// Copyright (C) 2002, 2003, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include "rastermeta.h"
#include "rasterframe.h"
#include "widget/spinner.h"
#include "widget/filesel.h"
#include "widget/subpanel.h"
#include "widget/wmisc.h"
#include <gtkmm/togglebutton.h>
#include <gtkmm/separator.h>
#include <gtkmm/sizegroup.h>
#include "safeslot.h"
#include <util/warning.h>

Pagent* RasterMeta::load(const xmlpp::Element& node, Group* parent){
  return new Raster_Frame(parent, node);
}

namespace {
  class PropRaster : public GenericProp<Raster_Frame> {
  public:
    PropRaster();
    
    void update();
    void apply();
  
    void toggleAspect();
    void change_val(bool x_active);
  private:
    float last_x, last_y;
    bool use_aspect;
    
    File_Entry e_fname;
    Spinner e_ppix, e_ppiy;
    Gtk::ToggleButton b_ppic;
    Gtk::HSeparator hsep;
  };
};

PropBase* RasterMeta::getProp() {
  return new PropRaster;
}

PropRaster::PropRaster()
  :GenericProp<Raster_Frame>("_Raster"), use_aspect(false),
   e_fname("Associated File"),  b_ppic("}", Gtk::JUSTIFY_RIGHT)
{
  Gtk::Label *label;
  Gtk::Box *line = manage(new Gtk::HBox(false, double_space));
  label = manage(new Gtk::Label("_Filename:", 0.0, 0.5, true));
  label->set_mnemonic_widget(e_fname);
  line->pack_start(*label, Gtk::PACK_SHRINK);
  line->pack_start(e_fname);
  pack_start(*line, Gtk::PACK_SHRINK);
  
  Glib::RefPtr<Gtk::SizeGroup>  sizegroup = 
    Gtk::SizeGroup::create(Gtk::SIZE_GROUP_HORIZONTAL);
  
  SubPanel* rezpanel = manage(new SubPanel("Raster resolution"));
  Gtk::Box *hbox = manage(new Gtk::HBox(false, single_space));
  Gtk::Box *vbox = manage(new Gtk::VBox(false, single_space));
  line = manage(new Gtk::HBox(false, double_space));
  line->pack_start(*(label = manage(new Gtk::Label("_Horizontal:", 
						   0.0, 0.5, true))),
		   Gtk::PACK_SHRINK);
  sizegroup->add_widget(*label);
  label->set_mnemonic_widget(e_ppix);
  line->pack_start(e_ppix, Gtk::PACK_SHRINK);
  line->pack_start(*(manage(new Gtk::Label("ppi"))),
		   Gtk::PACK_SHRINK);
  vbox->pack_start(*line, Gtk::PACK_SHRINK);
  
  line = manage(new Gtk::HBox(false, double_space));
  line->pack_start(*(label = manage(new Gtk::Label("_Vertical:", 
						   0.0, 0.5, true))),
		   Gtk::PACK_SHRINK);
  sizegroup->add_widget(*label);
  label->set_mnemonic_widget(e_ppiy);
  line->pack_start(e_ppiy, Gtk::PACK_SHRINK);
  line->pack_start(*(manage(new Gtk::Label("ppi"))),
		   Gtk::PACK_SHRINK);
  vbox->pack_start(*line, Gtk::PACK_SHRINK);


  hbox->pack_start(*vbox, Gtk::PACK_SHRINK);
  hbox->pack_start(b_ppic, Gtk::PACK_SHRINK);
  rezpanel->pack_start(*hbox, Gtk::PACK_SHRINK);

  pack_start(*rezpanel, Gtk::PACK_SHRINK);
  
  // Todo: Safeslot * 3 here!
  e_ppix.signal_changed.connect
    (bind(slot(*this, &PropRaster::change_val), true));
  e_ppiy.signal_changed.connect
    (bind(slot(*this, &PropRaster::change_val), false));
  b_ppic.signal_toggled().connect
    (safeslot(*this, &PropRaster::toggleAspect));
  b_ppic.set_active(true);
  set_sensitive(false);
  update();
}

void PropRaster::update() {
  if(object) {
    e_fname.entry.set_text(object->get_association());
    
    const Vector ppi = object->get_ppi();
    e_ppix.set(ppi.x);
    e_ppiy.set(ppi.y);
    
  } else {
    e_fname.entry.set_text("");
  }
}
void PropRaster::apply() {
  if(!object) return;
  object->set_ppi(Vector(e_ppix.get(), e_ppiy.get()));
  object->set_association(e_fname.entry.get_text());
}

void PropRaster::toggleAspect() {
  use_aspect = b_ppic.get_active();
  if(object && use_aspect) {
    e_ppiy.set(e_ppix.get());	// Todo: * object->getAspectRatio()
  }
}

void PropRaster::change_val(bool x_active) {
  // The reason for all these temporary (and instance) x/y variables is that
  // i get "changed signals" (calls here) even when the change comes from
  // here, so I have to make sure I don't change anything the second time
  // around ...
  try {
    if(use_aspect) {
      const float x(e_ppix.get()), y(e_ppiy.get());
      if(x_active) {
	if(x != last_x) {
	  last_x = x; last_y = x; // Todo: * object->getAspectRatio()
	  e_ppiy.set(last_y);
	}
      } else {
	if(y != last_y) {
	  last_y = y; last_x = y; // Todo: / object->getAspectRatio()
	  e_ppix.set(last_x);
	}
      }
    }
  } catch(const std::exception& err) {
    warning << "Oups: " << err.what() << " (in change_val)" << std::endl;
  }
}
