#ifndef SAFESLOT_H		// -*- c++ -*-
#define SAFESLOT_H
///
// Copyright (C) 2002, 2003, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include "errordialog.h"
#include <sigc++/slot.h>
#include <sigc++/object_slot.h>
#include <stdexcept>

#if 1
// This has a logn way to go ...  We need a working way to attach a try/catch
// block to a signal ...  For now, just pass through.  This is _not_ exception
// safe.

#define safeslot slot

#else
template <class R>
struct ExceptionSafeSlot0 : public SigC::AdaptorSlot_ {
#ifdef SIGC_CXX_PARTIAL_SPEC
  typedef R RType;
#else
  typedef typename Trait<R>::type RType;
#endif
  typedef SigC::Slot0<R> SlotType;
  typedef SigC::AdaptorNode Node;
  typedef SigC::CallDataObj2<typename SlotType::Func,Node> CallData;
  
  static RType callback(void* d) {
    try {
      CallData* data=(CallData*)d;
      Node* node=data->obj;
      return ((typename SlotType::Callback&)(node->data_))();
    } catch(const std::exception& err) {
      Error_Dialog::view(err.what());
      return RType();		// A default return value if needed.
    }
  }
  static SigC::SlotData* create(SigC::SlotData *s) {
    Node *node=new Node();
    copy_callback(s,node);
    CallData &data=reinterpret_cast<CallData&>(s->data_);
    data.callback=&callback;
    data.obj=node;
    return s;
  }
};

template<class R>
SigC::SlotData* safeslot(const SigC::Slot0<R>& slot) {
  return ExceptionSafeSlot0<R>::create(slot.data());
}

template <class R,class O,class O2>
inline SigC::Slot0<R> safeslot(O* &obj,R (O2::*func)()) {
  return safeslot(SigC::slot(obj, func));
}

template <class R,class O,class O2>
inline SigC::Slot0<R> safeslot(O* const &obj,R (O2::*func)()) {
  return safeslot(SigC::slot(obj, func));
}

template <class R,class O,class O2>
inline SigC::Slot0<R> safeslot(O &obj,R (O2::*func)()) {
  return safeslot(SigC::slot(obj, func));
}
#endif
#endif
