#ifndef STREAMDIALOG_H		// -*- c++ -*-
#define STREAMDIALOG_H
///
// Copyright (C) 2002, 2003, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include "widget/filesel.h"
#include "widget/dialogwrap.h"
#include <gtkmm/entry.h>
#include <gtkmm/optionmenu.h>
#include <gtkmm/menu.h>
#include <gtkmm/treeview.h>
#include <gtkmm/liststore.h>

class Text_Stream;
class Document;

/**
 * List of Streams and their properties.
 * This Dialog lets the user select what data file and which transform to
 * apply for a specific stream.
 */
class Stream_Dialog: public DialogWrap {
public:
  Stream_Dialog();
  ~Stream_Dialog();
  void show_raise(); // Make sure this dialog is visible
  void set_document(Document *document_);
  
private:
  Glib::RefPtr<Gtk::ListStore> main_model;
  Gtk::TreeView stream_list;
  
  Gtk::Widget *propsbox;
  
  Gtk::Entry name_entry;
  File_Entry file_entry;
  File_Entry xfrm_entry;
  
  Document *document;
  Text_Stream* current_stream;
  
  void update(Document *document_); // called when the document streams 
                                    // have changed in any way
  void on_response(int response_id);
  void on_selection_changed();
};


class Stream_Menu: public Gtk::OptionMenu {
public:
  Stream_Menu();
  
  void set_document(Document *document_);

  // select_name must be an existing name in the document or an empty
  // string, which means no stream
  void update(std::string select_name="");

  std::string get_stream() const;

private:
  Document *document;
  Gtk::Menu menu;
};

#endif
