#ifndef TEXTFRAME_H		// -*- c++ -*-
#define TEXTFRAME_H
///
// Copyright (C) 2002, 2003, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include "cachedframe.h"
#include "textstream.h"

class Text_Frame : public Cached_Frame {
public:
  Text_Frame(Group *parent, Text_Stream *stream,
	     float w, float h);
  Text_Frame(Group *parent, const xmlpp::Element& node);
  virtual ~Text_Frame();

  virtual xmlpp::Element *save(xmlpp::Element& parent_node) const;
  virtual void print(std::ostream &out, bool grayscale = false) const;


  // *** undoable actions ***
  void set_stream(Text_Stream *text_stream, 
		  bool remove_from_old = true, 
		  bool push_undo = false);
  // the destructor of Text_Stream sets remove_from_old = false
  // in order not to get a segmentation violation
  void set_num_columns(unsigned int columns, bool push_undo = false);
  void set_gutter(const float& gutter, bool push_undo = false);
  void set_size(float w, float h, bool push_undo = false); // overrides Pagent


  // *** probe state ***
  Text_Stream *get_stream() const {return text_stream;}
  //may return null
  unsigned int get_num_columns() const { return num_columns; }
  float get_gutter() const { return gutter_width; }

  // Another class (Text_Stream) may use these methods to create a ps
  // for this frame:
  const Glib::ustring &get_parsed_file() const {return parsed_file;}
  // the frame will not try to read the ps between calls to
  // begin- and end_write_ps
  void begin_write_ps(); 
  void end_write_ps(bool _ps_exists = true);

private:
  void generate_picture(View& view);

  // for making end_write_ps() thread safe:
  Glib::Dispatcher signal_end_write_ps;
  void _end_write_ps();

  bool ps_exists, parsed_file_lock;
  Glib::ustring parsed_file;
  Text_Stream *text_stream;
  unsigned int num_columns;
  float gutter_width;
};

#endif
