///
// Copyright (C) 2002, 2003, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include "textmeta.h"
#include "textframe.h"
#include "streamdialog.h"
#include "widget/wmisc.h"
#include <gtkmm/separator.h>
#include "widget/spinner.h"
#include "widget/subpanel.h"
#include "document.h"
#include <gtkmm/sizegroup.h>

Pagent* TextMeta::load(const xmlpp::Element& node, Group* parent) {
  return new Text_Frame(parent, node);
}

class PropText : public GenericProp<Text_Frame> {
public:
  PropText()
    : GenericProp<Text_Frame>("Te_xt"),
     e_columns(1, false), e_gutter(0, true, &length_units)
  {
    Glib::RefPtr<Gtk::SizeGroup>  sizegroup = 
      Gtk::SizeGroup::create(Gtk::SIZE_GROUP_HORIZONTAL);
    
    Gtk::Box *line = manage(new Gtk::HBox(false, single_space));
    Gtk::Label *label;
    line->pack_start(*(label = manage(new Gtk::Label("_Stream:",
						     0.0, 0.5, true))),
		     Gtk::PACK_SHRINK);
    sizegroup->add_widget(*label);
    label->set_mnemonic_widget(e_stream);
    
    line->pack_start(e_stream);
    pack_start(*line, Gtk::PACK_SHRINK);
    
    SubPanel *box = manage(new SubPanel("Columns"));
    line = manage(new Gtk::HBox(false, double_space));
    line->pack_start(*(label = manage(new Gtk::Label("Number of _columns:", 
						     0.0, 0.5, true))),
		     Gtk::PACK_SHRINK);
    sizegroup->add_widget(*label);
    label->set_mnemonic_widget(e_columns);
    e_columns.limits(1, 64);	// Note: The upper limit is rather arbitrary.
    line->pack_start(e_columns, Gtk::PACK_SHRINK);
    box->pack_start(*line);
    
    line = manage(new Gtk::HBox(false, double_space));
    line->pack_start(*(label = manage(new Gtk::Label("_Gutter width:",
						     0.0, 0.5, true))),
		     Gtk::PACK_SHRINK);
    sizegroup->add_widget(*label);
    label->set_mnemonic_widget(e_gutter);
    line->pack_start(e_gutter, Gtk::PACK_SHRINK);
    box->pack_start(*line);
    pack_start(*box, Gtk::PACK_SHRINK);
    
    set_sensitive(false);
    update();
  }
  
  void update() {
    if(object) {
      //The text stream of a text frame may be null.
      //This will happen, for instance, when the stream 
      //associated with the frame is deleted.
      e_stream.set_document(&Document::containing(*object));
      if(object->get_stream()) 
	e_stream.update(object->get_stream()->get_name());
      else
	e_stream.update();
      e_columns.set(object->get_num_columns());
      e_gutter.set(object->get_gutter());
    } else {
      e_stream.set_document(0);
      e_stream.update();
    }
  }
  void apply() {
    if(!object) return;
    object->set_num_columns(int(e_columns.get()));
    object->set_gutter(e_gutter.get());
    Text_Stream *stream=
      Document::containing(*object).get_text_stream(e_stream.get_stream());
    object->set_stream(stream);
  }
  
private:
  Gtk::HSeparator hsep;
  Stream_Menu e_stream;
  Spinner e_columns, e_gutter;
};

PropBase* TextMeta::getProp() {
  return new PropText;
}

