#ifndef UNDODIALOG_H		// -*- c++ -*-
#define UNDODIALOG_H
#include "widget/dialogwrap.h"
#include <gtkmm/treeview.h>
#include <gtkmm/liststore.h>

namespace Gtk {
  class Button;
};

class Document;

class Undo_Dialog : public DialogWrap {
public:
  Undo_Dialog();
  ~Undo_Dialog();
  void show_raise();
  void set_document(Document *_document);

private:
  bool locked;
  Gtk::TreeView *action_list;
  Gtk::Button *undo_button, *redo_button;
  Glib::RefPtr<Gtk::ListStore> tree_model;
  Document *document;
  bool on_button_release_event(GdkEventButton* event);
  void on_selection_changed();
  void on_response(int response_id);
  void on_undo_changed(Document *_document);
  void update(bool only_if_visible = true);
};

#endif
