#ifndef VIEW_H			// -*- c++ -*-
#define VIEW_H
///
// Copyright (C) 2002, 2003, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include "util/matrix.h"	// Just to get Vector.  Put in own file?
#include <gdkmm/drawable.h>

namespace Color {
  typedef enum Id { bg, frame, locked, guide, empty };
}

class View {
public:
  virtual Glib::RefPtr<Gdk::Drawable> get_win() = 0;
  virtual Glib::RefPtr<Gdk::GC> get_gc() = 0;
  
  virtual double get_scrres() const = 0;
  virtual float pt2scr(float pt) const = 0;
  virtual Gdk::Point pt2scr(const Vector& pt) const = 0;
  virtual Vector scr2pt(const Gdk::Point& scr) const = 0;
  virtual float scr2pt(const float scr) const = 0;

  virtual Glib::RefPtr<const Gdk::Pixmap> get_wait_pixmap() const = 0;
  virtual Glib::RefPtr<const Gdk::Pixmap> get_missing_pixmap() const = 0;
  virtual Glib::RefPtr<const Gdk::Pixmap> get_broken_pixmap() const = 0;

  
  virtual const Gdk::Color& get_color(Color::Id color) const = 0;
};

#endif
