///
// Copyright (C) 2002, 2003, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include <glibmm.h>
#include "webbrowser.h"
#include "errordialog.h"
#include "globals.h"  // version
#include "util/filesys.h"

namespace {
  std::string browser = "gnome-moz-remote";
}

const std::string homepage = "http://www.stacken.kth.se/project/pptout/";

void open_url(const std::string &url) {
  try {
    Glib::spawn_command_line_async(browser + " \"" + url + "\"");
  } catch(Glib::SpawnError e) {
    Error_Dialog::view("Couldn't run " + browser + "\n\n" + e.what());
  }
}

void open_homepage() {open_url(homepage);}

void open_docs() {
  std::string url = DOCDIR "/users_guide.html";
  if(access(url))
    url = "file://" + url;
  else
    url = "http://www.stacken.kth.se/project/pptout/doc/" 
      + version 
      + "/users_guide.html";
  open_url(url);
}
