// -*- c++ -*-
///
// Copyright (C) 2002, 2003, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#ifndef FILESEL_H
#define FILESEL_H

#include <gtkmm/fileselection.h>
#include <gtkmm/box.h>
#include <gtkmm/combo.h>

class Filesel;

class End_Entry: public Gtk::Combo {
public:
  End_Entry(int _history_max = 5);
  void set_text(const Glib::ustring &text);
  Glib::ustring get_text(bool remember_text = true);
  void remember(); // add current text to history
private:
  unsigned int history_max;
  typedef std::list<Glib::ustring> History;
  History history;
};

class File_Entry: public Gtk::HBox {
public:
  End_Entry entry;
  File_Entry(const Glib::ustring& window_title_, 
	     const Glib::ustring& default_path_ = "");
  ~File_Entry();

protected:
  /** Direct focus to the proper part of the Spinner. */
  bool on_mnemonic_activate(bool group_cycling);

private:
  Glib::ustring window_title, default_path;
  Gtk::Button button;
  Filesel *filesel;
  void filesel_done();
  void show_filesel();
};

//file selection dialog
class Filesel: public Gtk::FileSelection {
 public:
  Filesel(Gtk::Window &parent, const Glib::ustring& title);
  bool was_cancelled() const
  {return cancelled;}

private:
  void on_response(int response_id);
  bool cancelled;
};

#endif

