///
// Copyright (C) 2002, 2003, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include "spinner.h"
#include <gtkmm/adjustment.h>
//#include <iostream> // debug

class UnitAdjustment: public Gtk::Adjustment {
public:
  UnitAdjustment(double value, double lower, double upper, 
		 double step_increment = 1, double page_increment = 10, 
		 double page_size = 0) 
    : Adjustment(value, lower, upper, step_increment, 
		 page_increment, page_size),
      factor(1), low(lower), upp(upper)
  {}
  void set_factor(double _factor = 1) {
    double val = get_real_value();
    factor = _factor; 
    set_lower(low); set_upper(upp);
    set_value(val); 
  }
  void set_value(double value) {
    Adjustment::set_value(value / factor);
  }
  double get_real_value() const {return get_value() * factor;}
  void set_lower(double lower) {
    low = lower;
    Adjustment::set_lower(lower / factor);
  }
  double get_real_lower() const {return low;}
  void set_upper(double upper) {
    upp = upper;
    Adjustment::set_upper(upper / factor);
  }
  double get_real_upper() const {return upp;}
private:
  double factor, low, upp;
};

Spinner::Spinner(const float _value, bool allow_float, 
		 const FUUnits *_units)
  : units(_units)
{
  value = new UnitAdjustment(_value, -8000, 8000),

  spinbutton = manage(new Gtk::SpinButton(0, allow_float? 2: 0));
  spinbutton->set_adjustment(*value);
  spinbutton->set_numeric(false);
  if(!allow_float) spinbutton->set_snap_to_ticks(true);
  pack_start(*spinbutton);
  spinbutton->signal_changed().connect(signal_changed.slot());
  
  if(units) {
    menu = manage(new Gtk::Menu());
    using namespace Gtk::Menu_Helpers;
    MenuList& menu_list = menu->items();
    FUUnits::UnitList list = units->list_units();
    const Glib::ustring &base_unit = units->get_base_unit();
    // putting the base unit first makes it the the default
    menu_list.push_back(MenuElem(base_unit)); 
    for(FUUnits::UnitList::const_iterator i = list.begin();
	i != list.end();
	i++) {
      if(*i != base_unit)
	menu_list.push_back(MenuElem(*i));
    }
    optionmenu = manage(new Gtk::OptionMenu());
    optionmenu->set_menu(*menu);
    menu->signal_selection_done().connect
      (slot(*this, &Spinner::on_unit_select));

    optionmenu->set_size_request(-1, spinbutton->get_height());
    pack_start(*optionmenu);
    //    set_unit(units->get_base_unit());
  }
  show_all();
}

Spinner::~Spinner() {
  delete value;
}

void Spinner::limits(const float& low, const float& high) {
  value->set_lower(low);
  value->set_upper(high);
}

void Spinner::set_unit(const Glib::ustring &unit) {
  Gtk::Menu_Helpers::MenuList::const_iterator i = menu->items().begin();
  while (i != menu->items().end()) {
    const Gtk::Label *label = dynamic_cast<const Gtk::Label*>(i->get_child());
    if(label && (label->get_text() == unit))
      i->select();
  }
}

void Spinner::set(const float& _value) { 
  value->set_value(_value);
}

float Spinner::get() const {
  return value->get_real_value();
}

bool Spinner::on_mnemonic_activate(bool group_cycling) {
  // Not much documentet in gtkmm, but it seems this metod gets called when
  // this widget is activated (by a mnemonic e.g. from a label) so I can put
  // focus on the proper part of the widget.
  spinbutton->grab_focus();
  return true;
}

void Spinner::on_unit_select() {
  const Gtk::Label *label = 
    dynamic_cast<const Gtk::Label*>(optionmenu->get_child());
  if(!label)
    return;
  if(units) {
    try {
      value->set_factor(units->get_factor(label->get_text()));
      //      spinbutton->update();
    } catch(unknown_unit_error) {}
  }
}

