#ifndef WINDOW_H		// -*- c++ -*-
#define WINDOW_H
///
// Copyright (C) 2002, 2003, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include "docview.h"
#include <gtkmm/window.h>

class Icons;
class Pagesel;
class Filesel;
class Print_Dialog;
class Stream_Dialog;
class PropertiesDialog;
class Doc_Props_Dialog;
class Undo_Dialog;

namespace Gtk {
  class Button;  class ToggleButton;
  class ScrolledWindow;
  class Menu; class MenuItem; class MenuBar;
  class OptionMenu;
  class Toolbar;
  class Statusbar;
}

/**
 * The main window containing a view of a Document.
 */
class Frame_Window : public Gtk::Window 
{
public:
  Frame_Window(const Glib::ustring &filename = "", Document *document = 0);
  ~Frame_Window();

protected:
  bool on_delete_event(GdkEventAny*);
  bool on_focus_in_event(GdkEventFocus*);
  bool on_key_press_event(GdkEventKey*);

private:
  static Frame_Window *active_window; // pointer to the currently active window
  static PropertiesDialog *properties_dialog;
  static Stream_Dialog *stream_dialog;
  static Doc_Props_Dialog *doc_props_dialog;
  static Undo_Dialog *undo_dialog;
  Gtk::Toolbar *toolbar;
  Gtk::ScrolledWindow *scroller;
  Gtk::Statusbar *cafe_opera;
  Gtk::MenuBar *menubar;
  Gtk::OptionMenu *zoom_factor;
  Filesel *open_dialog, *save_dialog, *import_dialog;
  Document_View document_view;
  Print_Dialog *print_dialog;
  Pagesel *pagesel;
  Glib::ustring preview_tmp_file; // temp file to write ps to when previewing
  Gtk::Menu *page_menu, *edit_menu, *view_menu;
  Gtk::MenuItem *save_item, *save_as_item, *print_item, *preview_item, 
    *delete_page_item, *undo_item, *redo_item, *props_item, *prefs_item;
  Gtk::Button *save_button, *text_frame_button, *image_frame_button;
  Gtk::Button *streams_button, *preview_button, *properties_button;
  Gtk::ToggleButton *grid_button;

  // We need to create separate copies of the icons for each window since each
  // icon can only have one parent
  Icons *icons; 

  void set_filename(const Glib::ustring&);

  void on_document_updated(Document *document_); // change IN document
  void on_document_changed(); // change OF document
  void on_document_filename_changed(Document *document_); 

  void new_document();
  void print_to_viewer() const;
  static void quit();

  bool zoom_lock; // avoid signal loops
  void zoom_change_action(float);
  void zoom_factor_changed_action();
  Gtk::Menu* create_zoom_menu();

  void create_menus();
  void toggle_cafe_opera();
  void toggle_toolbar();
  void open_dialog_done();
  void save_dialog_done();
  void import_dialog_done();
  void save();
  void close();
  void on_grid_button_clicked();
  void do_nothing() const; // for unimplemented functions

  void show_doc_props_dialog();
  void show_template_page_dialog();
};

#endif







