// -*- c++ -*-
///
// Copyright (C) 2002, 2003, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#ifndef WINEPS_H 
#define WINEPS_H

#include <string>
#include <fstream>

// A filter that extracts the ps code from all the junk in a Windows EPS.
// Works on ordinary EPS files as well.

namespace PS {
  class WinEPSFilter {
    // Perhaps this should be a subclass of ifstream, but I don't know
    // how to do that
  public:
    WinEPSFilter(const std::string &filename);
    WinEPSFilter &getline(std::string &line);
    operator bool() const {return in && ok;}

  private:
    bool ok, win;
    unsigned long start, length;
    std::ifstream in;
  };
}

PS::WinEPSFilter &getline(PS::WinEPSFilter &in, std::string &line);

#endif
