///
// Copyright (C) 2002, 2003, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include "stringutil.h"
#include <cstdlib>
#include <cctype>

template<> bool to<bool>(const std::string& value) {
  if(value == "true" || value == "1") return true;
  if(value == "false" || value == "0") return false;
  throw std::runtime_error("Bad value: \"" + value + "\" for bool");
}

template<> std::string tostr(const bool& b) {
  return b? "true": "false";
}

bool whitespace(char c)
{
  return std::isspace(c);
}

std::string strip_whitespace(std::string s, bool front, bool back)
{
  int b=0;
  int l=s.length()-1;
  while(front && b<=l && whitespace(s[b]))
    b++;
  while(back && l>=0 && whitespace(s[l]))
    l--;
  return s.substr(b, l-b+1);
}

bool starts_with(const std::string& str, const std::string& start) {
  std::string::size_type len = start.length();
  return str.length() >= len && str.substr(0, len) == start;
}
