#include "stringutil.h"
#include "testbed/testbed.hh"

template<class Value>
class TestStringConvert : public TestCase {
public:
  TestStringConvert(std::string input, Value value)
    : TestCase("StringConvert " + input),
      input_(input), value_(value)
    {}
  
  void test() {
    ASSERT(value_ == to<Value>(input_));
    ASSERT(input_ == tostr(value_));
  }
  
private:
  const std::string input_;
  const Value value_;
};

namespace {
  TestStringConvert<float> t1("14", 14);
  TestStringConvert<float> t3("-14.2", -14.2);
  TestStringConvert<int>   t4("4711", 4711);
  TestStringConvert<int>   t5("-17", -17);
  TestStringConvert<bool>  t6("true", true);
  TestStringConvert<bool>  t7("false", false);
}
