#include "undo.h"
// #include <iostream> // debug

using namespace undo;

Undoable::~Undoable() {
  clear_redos();
  for(Stack::iterator i = stack.begin(); i != stack.end(); i++) {
    delete *i;
  }
}

void Undoable::push_action(Action *action) {
  //  std::cerr << stack.size() << " push ";
  clear_redos();
  stack.push_back(action);
  trim();
  //  std::cerr << stack.size() << std::endl;
  on_stack_change();
}

void Undoable::undo(bool push_redo) {
  //  std::cerr << stack.size() << " undo ";
  if(!stack.size())
    return; 
  stack.back()->undo();
  if(push_redo) {
    redo_stack.push_back(stack.back());
  } else {
    delete stack.back();
  }
  stack.pop_back();
  //  std::cerr << stack.size() << std::endl;
  on_stack_change();
}

void Undoable::redo(bool push_undo) {
  //  std::cerr << stack.size() << " redo ";
  if(!redo_stack.size())
    return;
  redo_stack.back()->redo();
  if(push_undo)
    stack.push_back(redo_stack.back());
  redo_stack.pop_back();
  //  std::cerr << stack.size() << std::endl;
  on_stack_change();
}

void Undoable::set_save_mark() {
  if(!stack.size())
    return;
  stack.back()->set_save_mark(true);

  // clear all other save marks
  Stack::reverse_iterator i = stack.rbegin(); i++;
  while(i != stack.rend()) {
    (*(i++))->set_save_mark(false);
  }

  on_stack_change();
}

int Undoable::get_undo_count() const {
  return stack.size();
}

int Undoable::get_redo_count() const {
  return redo_stack.size();
}

bool Undoable::has_been_saved() const {
  return (stack.size() == 0) || stack.back()->get_save_mark();
}

const Action *Undoable::get_action(int index) {
  // Todo: This is inefficient
  if(index >= 0) {
    Stack::reverse_iterator i = stack.rbegin();
    while(i != stack.rend()) {
      if(index == 0)
	return *i;
      index--; i++;
    }
    return 0;
  } else {
    Stack::reverse_iterator i = redo_stack.rbegin();
    index++;
    while(i != redo_stack.rend()) {
      if(index == 0)
	return *i;
      index++; i++;
    }
    return 0;
  }
}

void Undoable::set_max(int _max) {
  unsigned int size = stack.size();
  max = _max;
  trim();
  if(size != stack.size())
    on_stack_change();
};

void Undoable::clear_redos() {
  for(Stack::iterator i = redo_stack.begin(); i != redo_stack.end(); i++) {
    delete *i;
  }
  redo_stack.clear();
}

void Undoable::trim() {
  if(max > 0) {
    while(int(stack.size()) > max) {
      delete stack.front();
      stack.pop_front();
    }
  }
}
