/* $Id: hellodl.c,v 1.1.2.3 2002/05/28 15:22:01 tm Exp $
 * PDFlib client: hello example in C with dynamic DLL loading
 *
 */

#include <stdio.h>
#include <stdlib.h>

#include "pdflibdl.h"

int
main(void)
{
    PDF *p;
    int font;
    PDFlib_api *PDFlib = PDF_boot_dll();
    
    if (PDFlib == NULL)
    {
	fprintf(stderr, "Error: couldn't load PDFlib DLL.\n");
	return 0;
    }

    p = PDFlib->PDF_new();

    /* open new PDF file */
    if (PDFlib->PDF_open_file(p, "hellodl.pdf") == -1) 
    {
	fprintf(stderr, "Error: cannot open PDF file hellodl.pdf.\n");
	exit(2);
    }

    PDFlib->PDF_set_info(p, "Creator", "hello.c");
    PDFlib->PDF_set_info(p, "Author", "Thomas Merz");
    PDFlib->PDF_set_info(p, "Title", "Hello, world (C DLL)!");

    PDFlib->PDF_begin_page(p, a4_width, a4_height);	/* start a new page */

    /* Change "host" encoding to "winansi" or whatever you need! */
    font = PDFlib->PDF_findfont(p, "Helvetica-Bold", "host", 0);

    PDFlib->PDF_setfont(p, font, 24);
    PDFlib->PDF_set_text_pos(p, 50, 700);
    PDFlib->PDF_show(p, "Hello, world!");
    PDFlib->PDF_continue_text(p, "(says C DLL)");
    PDFlib->PDF_end_page(p);			/* close page */

    PDFlib->PDF_close(p);			/* close PDF document */

    PDFlib->PDF_delete(p);			/* delete the PDF object */

    PDF_shutdown_dll(PDFlib);			/* unload the library */

    return 0;
}
