#!/bin/sh
# $Id: personalize.tcl,v 1.8.2.1 2002/01/28 17:16:51 rp Exp $
#
# PDFlib/PDI client: personalization demo
#

# Hide the exec to Tcl but not to the shell by appending a backslash\
exec tclsh "$0" ${1+"$@"}

# The lappend line is unnecessary if PDFlib has been installed
# in the Tcl package directory
set auto_path [linsert $auto_path 0 .libs .]

package require pdflib 4.0

set infile	"../../doc/PDFlib-purchase-order.pdf"
set col1	70
set col2	335

set p [PDF_new]

if {[PDF_open_file $p "personalize.pdf"] == -1} {
    puts stderr "Error: cannot open PDF file 'personalize.pdf'!"
    exit
}

PDF_set_info $p "Creator" "personalize.tcl"
PDF_set_info $p "Author" "Thomas Merz"
PDF_set_info $p "Title" "PDFlib personalization demo (Tcl)"

set form [PDF_open_pdi $p $infile "" 0]
if {$form == -1} {
    puts stderr "Couldn't open input file '$infile'."
    exit
}

set page [PDF_open_pdi_page $p $form 1 ""]
if {$page == -1} {
    puts stderr "Couldn't open page 1 in '$infile'."
    exit
}

set font [PDF_findfont $p "Helvetica-Bold" "host" 0]

# get the dimensions of the imported form
set width [PDF_get_pdi_value $p "width" $form $page 0]
set height [PDF_get_pdi_value $p "height" $form $page 0]

PDF_begin_page $p $width $height
PDF_place_pdi_page $p $page 0 0 1 1
PDF_close_pdi_page $p $page

PDF_setfont $p $font 18
PDF_set_value $p "leading" 24
PDF_set_text_pos $p $col1 486

PDF_show $p "Doublecheck, Inc."
PDF_continue_text $p "Petra Porst"
PDF_continue_text $p "500, Market St."
PDF_continue_text $p "94110 San Francisco, CA"
PDF_continue_text $p ""
PDF_continue_text $p "USA"
PDF_continue_text $p "+1/950/123-4567"
PDF_continue_text $p "+1/950/123-4568"
PDF_continue_text $p ""
PDF_continue_text $p "petra@doublecheck.com"

PDF_set_text_pos $p $col2 104
PDF_continue_text $p [clock format [clock seconds] -format "%B %d, %Y"]

PDF_end_page $p
PDF_close $p
PDF_close_pdi $p $form
PDF_delete $p
