/*
 * Copyright 1999-2000 Vizdom Software, Inc. All Rights Reserved.
 * 
 *  This program is free software; you can redistribute it and/or 
 *  modify it under the same terms as the Perl Kit, namely, under 
 *  the terms of either:
 *
 *      a) the GNU General Public License as published by the Free
 *      Software Foundation; either version 1 of the License, or 
 *      (at your option) any later version, or
 *
 *      b) the "Artistic License" that comes with the Perl Kit.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See either
 *  the GNU General Public License or the Artistic License for more 
 *  details. 
 */

package com.vizdom.dbd.jdbc;

/**
 * Exceptions thrown by a DBD Connection, as distinct from exceptions
 * thrown by the JDBC driver. All of these exceptions (and the ones
 * generated by the client) have the same SQL state value: IJDBC. The
 * code numbers will be unique across the client and server.
 *
 * @author Gennis Emerson
 * @version $Revision: 1.9 $
 */
/* At the moment, internationalization of error messages means
 * editing and recompiling this class.
 *
 * The server owns error codes 0-99. The client owns error codes 100-199.
 * Make further code range assignments as needed.
 */
class DbdException extends java.sql.SQLException
{
    /** Client sent an invalid statement handle. */
    static final int gINVALID_STATEMENT_HANDLE          = 1;
    /** The request is only valid when there's a result set. */
    static final int gNO_RESULT_SET                     = 2;
    /** Unknown property name. */
    static final int gUNKNOWN_PROPERTY                  = 3;
    /** No cursor is present when one is called for. */
    static final int gNO_CURSOR                         = 4;
    /** No metadata is available. */
    static final int gNO_METADATA                       = 5;
    /** An unknown Ber request was received. */
    static final int gUNKNOWN_REQUEST                   = 6;
    /** The server has no response for the client. */
    static final int gNO_RESPONSE                       = 7;
    /** Send a random error string to the client. */
    static final int gGENERIC_EXCEPTION                 = 8;
    /** An error occurred during fetch. */
    static final int gFETCH_EXCEPTION                   = 9;
    /** The client's requested character encoding is not supported. */
    static final int gUNSUPPORTED_ENCODING              = 10;
    /** Error setting a parameter. */
    static final int gSET_PARAMETER                     = 11;
    /** Data was truncated. */
    static final int gDATA_TRUNCATION                   = 12;
        
    /** No object on which to call the method. */
    static final int gREFLECTION_OBJECT_MISSING         = 13;
    /** The object name is not known (for Statement reflection). */
    static final int gREFLECTION_INVALID_OBJECT         = 14;
    /** Java reflection-related exception. */
    static final int gREFLECTION_EXCEPTION              = 15;

    /** The messages for each exception. */
    private static final String[] sMessages =
    {   "[placeholder]",
        "Invalid statement handle",
        "No result set available; perhaps you need to call execute?",
        "Unknown property name {0}",
        "No cursor available; perhaps this statement is not active?",
        "No metadata available",
        "Unknown request type (BER tag {0})",
        "Failed to generate a response",
        "{0}",
        "Error fetching column {0} ({1})",
        "Unsupported character encoding {0}",
        "Failed to set parameter {0} ({1})",
        "Data truncation",
        "No object type provided in reflection method call",
        "{0} is not an available reflection object",
        "Reflection exception: {0}",
    };

    /** All errors generated by the server have this SQL state. */
    private static final String sSQL_STATE = "IJDBC";


    /**
     * Constructs the exception corresponding to the given code. 
     *
     * @param aCode one of the constants from this class
     */
    DbdException(int aCode)
    {
        this(aCode, new Object[0]);
    }

    /**
     * Constructs the exception corresponding to the given code. Substitutes
     * the parameter list into the message text.
     *
     * @param aCode one of the constants from this class
     * @param aParameterList passed to MessageFormat.format, along with 
     *      the message text
     */
    DbdException(int aCode, Object[] aParameterList)
    {
        super(java.text.MessageFormat.format(sMessages[aCode], aParameterList),
            sSQL_STATE, aCode);
    }
}
