/*
 *    pgfe 
 *
 *    Copyright(C) 2002 Adam Siegel
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 */

#include <stdio.h>
#include <gtk/gtk.h>
#include "interface.h"
#include "support.h"
#include "callbacks.h"

GtkWidget *window1;
GtkWidget *window2;
GtkWidget *window3;
GtkWidget *window4;
GtkWidget *window5;
GtkWidget *window6;
GtkWidget *window7;
GtkWidget *window8;
GtkWidget *window9;

int main(int argc, char *argv[])
{
     int i = 0;
     int conn = 0;
               
     gtk_set_locale();

     gtk_init(&argc, &argv);
  
     window1 = create_window1();
     window2 = create_window2();
     window3 = create_window3();
     window4 = create_window4();
     window5 = create_window5();
     window6 = create_window6();
     window7 = create_window7();
     window8 = create_window8();
     window9 = create_window9();

     init();

     gtk_entry_set_text(GTK_ENTRY(lookup_widget(window2, "entry1")), 
                        "localhost");
    
     if (getenv("USER"))
     {
          gtk_entry_set_text(GTK_ENTRY(lookup_widget(window2, "entry2")), 
                             (char*)getenv("USER"));
          gtk_entry_set_text(GTK_ENTRY(lookup_widget(window2, "entry3")), 
                             (char*)getenv("USER"));
     }

     loadPrefs();
    
     while (i < argc)
     {
          if (!strcmp(argv[i], "--help"))
          {
               puts("usage: pgfe -h host -d database -u username -p password");
               return 0;
          }
          else if (!strcmp(argv[i], "-h"))
          {
               gtk_entry_set_text(
                    GTK_ENTRY(lookup_widget(window2, "entry1")), argv[++i]);
          }
          else if (!strcmp(argv[i], "-d"))
          {
               gtk_entry_set_text(
                    GTK_ENTRY(lookup_widget(window2, "entry2")), argv[++i]);
          }
          else if (!strcmp(argv[i], "-u"))
          {
               gtk_entry_set_text(
                    GTK_ENTRY(lookup_widget(window2, "entry3")), argv[++i]);
          }
          else if (!strcmp(argv[i], "-p"))
          {
               gtk_entry_set_text(
                    GTK_ENTRY(lookup_widget(window2, "entry4")), argv[++i]);
          }
        
          i++;
     }
    
     on_button1_clicked(NULL, NULL);
    
     gtk_widget_show(window1);
     gtk_main();
  
     return 0;
}






