/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	
	
	$Id: PGPldapLibMain.c,v 1.11 1999/03/10 02:52:43 heller Exp $
____________________________________________________________________________*/

#include <CodeFragments.h>

#include "MacErrors.h"
#include "pgpUtilities.h"

pascal OSErr	INIT_PGPldapLib(const CFragInitBlock *theInitBlock);
pascal void		TERM_PGPldapLib(void);
pascal OSErr 	__initialize(const CFragInitBlock *theInitBlock);
pascal void 	__terminate(void);

static PGPBoolean	sInitializedLibrary = FALSE;

	pascal OSErr
INIT_PGPldapLib(const CFragInitBlock *theInitBlock)
{
	OSErr	err = noErr;
	
	#pragma unused( theInitBlock )
	
	err = __initialize( theInitBlock );
	if( IsntErr( err ) )
	{
		err = PGPErrorToMacError( PGPsdkNetworkLibInit() );
		if( IsntErr( err ) )
		{
			sInitializedLibrary = TRUE;
		}
	}
	
	pgpAssert( IsntErr( err ) );
	
	return( err );
}

	pascal void
TERM_PGPldapLib(void)
{
	if( sInitializedLibrary )
	{
		(void) PGPsdkNetworkLibCleanup();
		sInitializedLibrary = FALSE;
	}

	__terminate();
}
