/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.transformer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.transform.TransformerException;
import org.apache.xalan.serialize.Serializer;
import org.apache.xalan.serialize.SerializerFactory;
import org.apache.xalan.templates.OutputProperties;
import org.apache.xalan.transformer.TransformerImpl;
import org.xml.sax.ContentHandler;

public class SerializerSwitcher {
    private static String getOutputPropertyNoDefault(String qnameString, Properties props) throws IllegalArgumentException {
        String value = (String)((Hashtable)props).get(qnameString);
        return value;
    }

    public static Serializer switchSerializerIfHTML(String ns, String localName, Properties props, Serializer oldSerializer) throws TransformerException {
        Serializer newSerializer = oldSerializer;
        if ((ns == null || ns.length() == 0) && localName.equalsIgnoreCase("html")) {
            if (SerializerSwitcher.getOutputPropertyNoDefault("method", props) != null) {
                return newSerializer;
            }
            Properties prevProperties = props;
            OutputProperties htmlOutputProperties = new OutputProperties("html");
            htmlOutputProperties.copyFrom(prevProperties, true);
            Properties htmlProperties = htmlOutputProperties.getProperties();
            if (oldSerializer != null) {
                Serializer serializer = SerializerFactory.getSerializer(htmlProperties);
                Writer writer = oldSerializer.getWriter();
                if (writer != null) {
                    serializer.setWriter(writer);
                } else {
                    OutputStream os = serializer.getOutputStream();
                    if (os != null) {
                        serializer.setOutputStream(os);
                    }
                }
                newSerializer = serializer;
            }
        }
        return newSerializer;
    }

    public static void switchSerializerIfHTML(TransformerImpl transformer, String ns, String localName) throws TransformerException {
        if (transformer == null) {
            return;
        }
        if ((ns == null || ns.length() == 0) && localName.equalsIgnoreCase("html")) {
            if (transformer.getOutputPropertyNoDefault("method") != null) {
                return;
            }
            Properties prevProperties = transformer.getOutputFormat().getProperties();
            OutputProperties htmlOutputProperties = new OutputProperties("html");
            htmlOutputProperties.copyFrom(prevProperties, true);
            Properties htmlProperties = htmlOutputProperties.getProperties();
            try {
                Serializer oldSerializer = transformer.getSerializer();
                if (oldSerializer != null) {
                    Serializer serializer = SerializerFactory.getSerializer(htmlProperties);
                    Writer writer = oldSerializer.getWriter();
                    if (writer != null) {
                        serializer.setWriter(writer);
                    } else {
                        OutputStream os = serializer.getOutputStream();
                        if (os != null) {
                            serializer.setOutputStream(os);
                        }
                    }
                    transformer.setSerializer(serializer);
                    ContentHandler ch = serializer.asContentHandler();
                    transformer.setContentHandler(ch);
                }
            }
            catch (IOException e) {
                throw new TransformerException(e);
            }
        }
    }
}

