/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.transformer;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.serialize.Serializer;
import org.apache.xalan.serialize.SerializerFactory;
import org.apache.xalan.stree.Child;
import org.apache.xalan.stree.SourceTreeHandler;
import org.apache.xalan.templates.AVT;
import org.apache.xalan.templates.ElemAttributeSet;
import org.apache.xalan.templates.ElemCallTemplate;
import org.apache.xalan.templates.ElemForEach;
import org.apache.xalan.templates.ElemSort;
import org.apache.xalan.templates.ElemTemplate;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.ElemVariable;
import org.apache.xalan.templates.ElemWithParam;
import org.apache.xalan.templates.OutputProperties;
import org.apache.xalan.templates.Stylesheet;
import org.apache.xalan.templates.StylesheetComposed;
import org.apache.xalan.templates.StylesheetRoot;
import org.apache.xalan.templates.XUnresolvedVariable;
import org.apache.xalan.trace.TraceManager;
import org.apache.xalan.transformer.CountersTable;
import org.apache.xalan.transformer.KeyManager;
import org.apache.xalan.transformer.MsgMgr;
import org.apache.xalan.transformer.NodeSortKey;
import org.apache.xalan.transformer.ResultTreeHandler;
import org.apache.xalan.transformer.StackGuard;
import org.apache.xalan.transformer.TransformState;
import org.apache.xml.utils.BoolStack;
import org.apache.xml.utils.DOMBuilder;
import org.apache.xml.utils.DefaultErrorHandler;
import org.apache.xml.utils.NodeVector;
import org.apache.xml.utils.ObjectPool;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.QName;
import org.apache.xml.utils.SAXSourceLocator;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xpath.Arg;
import org.apache.xpath.VariableStack;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.objects.XRTreeFrag;
import org.apache.xpath.objects.XString;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class TransformerImpl
extends Transformer
implements Runnable,
TransformState {
    private Boolean m_reentryGuard = new Boolean(true);
    private FileOutputStream m_outputStream = null;
    private boolean m_parserEventsOnMain = true;
    private Thread m_transformThread;
    private String m_urlOfSource = null;
    private OutputProperties m_outputFormat;
    private Serializer m_serializer;
    ContentHandler m_inputContentHandler;
    private ContentHandler m_outputContentHandler = null;
    DocumentBuilder m_docBuilder = null;
    private ObjectPool m_textResultHandlerObjectPool = new ObjectPool("org.apache.xalan.transformer.ResultTreeHandler");
    private ObjectPool m_stringWriterObjectPool = new ObjectPool("java.io.StringWriter");
    private OutputProperties m_textformat = new OutputProperties("text");
    private NodeVector m_currentTemplateElements = new NodeVector(64);
    private NodeVector m_currentMatchTemplates = new NodeVector();
    private StylesheetRoot m_stylesheetRoot = null;
    private boolean m_quietConflictWarnings = true;
    private XPathContext m_xcontext;
    private StackGuard m_stackGuard = new StackGuard();
    private ResultTreeHandler m_resultTreeHandler;
    private KeyManager m_keyManager = new KeyManager();
    private Stack m_attrSetStack = null;
    private CountersTable m_countersTable = null;
    private BoolStack m_currentTemplateRuleIsNull = new BoolStack();
    private MsgMgr m_msgMgr;
    public static boolean S_DEBUG = false;
    private ErrorListener m_errorHandler = new DefaultErrorHandler();
    private TraceManager m_traceManager = new TraceManager(this);
    private Exception m_exceptionThrown = null;
    private Source m_xmlSource;
    private Node m_doc;
    private boolean m_isTransformDone = false;
    private boolean m_hasBeenReset = false;
    Vector m_userParams;

    public TransformerImpl(StylesheetRoot stylesheet) {
        this.setStylesheet(stylesheet);
        this.setXPathContext(new XPathContext(this));
        this.getXPathContext().setNamespaceContext(stylesheet);
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean applyTemplateToNode(ElemTemplateElement xslInstruction, ElemTemplateElement template, Node child, QName mode) throws TransformerException {
        short nodeType = child.getNodeType();
        boolean isDefaultTextRule = false;
        if (template == null) {
            boolean isApplyImports = xslInstruction == null ? false : xslInstruction.getXSLToken() == 72;
            int maxImportLevel = isApplyImports ? xslInstruction.getStylesheetComposed().getImportCountComposed() - 1 : -1;
            XPathContext xctxt = this.getXPathContext();
            PrefixResolver savedPrefixResolver = xctxt.getNamespaceContext();
            try {
                xctxt.setNamespaceContext(xslInstruction);
                template = this.m_stylesheetRoot.getTemplateComposed(xctxt, child, mode, maxImportLevel, this.m_quietConflictWarnings);
            }
            finally {
                Object var12_15 = null;
                xctxt.setNamespaceContext(savedPrefixResolver);
            }
            if (template == null) {
                switch (nodeType) {
                    case 1: 
                    case 11: {
                        template = this.m_stylesheetRoot.getDefaultRule();
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        template = this.m_stylesheetRoot.getDefaultTextRule();
                        isDefaultTextRule = true;
                        break;
                    }
                    case 9: {
                        template = this.m_stylesheetRoot.getDefaultRootRule();
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            }
        }
        try {
            try {
                this.pushPairCurrentMatched(template, child);
                if (isDefaultTextRule) {
                    switch (nodeType) {
                        case 3: 
                        case 4: {
                            this.m_resultTreeHandler.m_cloner.cloneToResultTree(child, false);
                            return true;
                        }
                        case 2: {
                            String val = ((Attr)child).getValue();
                            this.getResultTreeHandler().characters(val.toCharArray(), 0, val.length());
                            return true;
                        }
                        default: {
                            return true;
                        }
                    }
                }
                if (S_DEBUG) {
                    this.getTraceManager().fireTraceEvent(child, mode, template);
                }
                if (template.isCompiledTemplate()) {
                    template.execute(this, child, mode);
                    return true;
                }
                this.executeChildTemplates(template, child, mode);
                return true;
            }
            catch (SAXException se) {
                throw new TransformerException(se);
            }
        }
        finally {
            Object var8_8 = null;
            this.popCurrentMatched();
        }
    }

    public void clearParameters() {
        Boolean bl = this.m_reentryGuard;
        synchronized (bl) {
            VariableStack varstack = new VariableStack();
            this.getXPathContext().setVarStack(varstack);
            this.m_userParams = null;
        }
    }

    public ContentHandler createResultContentHandler(Result outputTarget) throws TransformerException {
        return this.createResultContentHandler(outputTarget, this.getOutputFormat());
    }

    public ContentHandler createResultContentHandler(Result outputTarget, OutputProperties format) throws TransformerException {
        ContentHandler handler;
        Node outputNode = null;
        if (outputTarget instanceof DOMResult) {
            Document doc;
            short type;
            outputNode = ((DOMResult)outputTarget).getNode();
            if (outputNode != null) {
                type = outputNode.getNodeType();
                doc = type == 9 ? (Document)outputNode : outputNode.getOwnerDocument();
            } else {
                doc = this.getXPathContext().getDOMHelper().createDocument();
                outputNode = doc;
                type = outputNode.getNodeType();
                ((DOMResult)outputTarget).setNode(outputNode);
            }
            handler = type == 11 ? new DOMBuilder(doc, (DocumentFragment)outputNode) : new DOMBuilder(doc, outputNode);
        } else if (outputTarget instanceof SAXResult) {
            handler = ((SAXResult)outputTarget).getHandler();
            if (handler == null) {
                throw new IllegalArgumentException("handler can not be null for a SAXResult");
            }
        } else if (outputTarget instanceof StreamResult) {
            StreamResult sresult = (StreamResult)outputTarget;
            String method = format.getProperty("method");
            try {
                Serializer serializer = SerializerFactory.getSerializer(format.getProperties());
                if (sresult.getWriter() != null) {
                    serializer.setWriter(sresult.getWriter());
                } else if (sresult.getOutputStream() != null) {
                    serializer.setOutputStream(sresult.getOutputStream());
                } else if (sresult.getSystemId() != null) {
                    String fileURL = sresult.getSystemId();
                    if (fileURL.startsWith("file:///")) {
                        fileURL = fileURL.substring(8);
                    }
                    this.m_outputStream = new FileOutputStream(fileURL);
                    serializer.setOutputStream(this.m_outputStream);
                } else {
                    throw new TransformerException("No output specified!");
                }
                handler = serializer.asContentHandler();
                this.setSerializer(serializer);
            }
            catch (UnsupportedEncodingException uee) {
                throw new TransformerException(uee);
            }
            catch (IOException ioe) {
                throw new TransformerException(ioe);
            }
        } else {
            throw new TransformerException("Can't transform to a Result of type " + outputTarget.getClass().getName() + "!");
        }
        return handler;
    }

    public Thread createTransformThread() {
        Thread t = new Thread(this);
        return t;
    }

    public boolean currentTemplateRuleIsNull() {
        return !this.m_currentTemplateRuleIsNull.isEmpty() && this.m_currentTemplateRuleIsNull.peek();
    }

    public void executeChildTemplates(ElemTemplateElement elem, Node sourceNode, QName mode) throws TransformerException {
        this.executeChildTemplates(elem, sourceNode, mode, true);
    }

    public void executeChildTemplates(ElemTemplateElement elem, Node sourceNode, QName mode, ContentHandler handler) throws TransformerException {
        ContentHandler savedHandler = this.getContentHandler();
        try {
            try {
                this.getResultTreeHandler().flushPending();
                this.setContentHandler(handler);
                this.executeChildTemplates(elem, sourceNode, mode);
            }
            catch (SAXException se) {
                throw new TransformerException(se);
            }
            Object var7_7 = null;
            this.setContentHandler(savedHandler);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.setContentHandler(savedHandler);
            throw throwable;
        }
    }

    public void executeChildTemplates(ElemTemplateElement elem, Node sourceNode, QName mode, boolean shouldAddAttrs) throws TransformerException {
        boolean check;
        ElemTemplateElement firstChild = elem.getFirstChildElem();
        if (firstChild == null) {
            return;
        }
        XPathContext xctxt = this.getXPathContext();
        boolean bl = check = StackGuard.m_recursionLimit > -1;
        if (check) {
            this.getStackGuard().push(elem, sourceNode);
        }
        VariableStack varstack = this.getXPathContext().getVarStack();
        varstack.pushElemFrame();
        SourceLocator savedLocator = xctxt.getSAXLocator();
        try {
            this.pushElemTemplateElement(null);
            ElemTemplateElement t = firstChild;
            while (t != null) {
                if (shouldAddAttrs || t.getXSLToken() != 48) {
                    xctxt.setSAXLocator(t);
                    this.m_currentTemplateElements.setTail(t);
                    t.execute(this, sourceNode, mode);
                }
                t = t.getNextSiblingElem();
            }
            Object var11_12 = null;
            this.popElemTemplateElement();
            xctxt.setSAXLocator(savedLocator);
            varstack.popElemFrame();
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            this.popElemTemplateElement();
            xctxt.setSAXLocator(savedLocator);
            varstack.popElemFrame();
            throw throwable;
        }
        if (check) {
            this.getStackGuard().pop();
        }
    }

    public String getBaseURLOfSource() {
        return this.m_urlOfSource;
    }

    public ContentHandler getContentHandler() {
        return this.m_outputContentHandler;
    }

    public NodeIterator getContextNodeList() {
        try {
            return this.getXPathContext().getContextNodeList().cloneWithReset();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public CountersTable getCountersTable() {
        if (this.m_countersTable == null) {
            this.m_countersTable = new CountersTable();
        }
        return this.m_countersTable;
    }

    public ElemTemplateElement getCurrentElement() {
        return (ElemTemplateElement)this.m_currentTemplateElements.peepTail();
    }

    public Node getCurrentNode() {
        return this.m_xcontext.getCurrentNode();
    }

    public ElemTemplate getCurrentTemplate() {
        ElemTemplateElement elem = this.getCurrentElement();
        while (elem != null && elem.getXSLToken() != 19) {
            elem = elem.getParentElem();
        }
        return (ElemTemplate)elem;
    }

    public ErrorListener getErrorListener() {
        return this.m_errorHandler;
    }

    public Exception getExceptionThrown() {
        return this.m_exceptionThrown;
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/trax/features/sax/input".equals(name)) {
            return true;
        }
        if ("http://xml.org/trax/features/dom/input".equals(name)) {
            return true;
        }
        throw new SAXNotRecognizedException(name);
    }

    public ContentHandler getInputContentHandler() {
        return this.getInputContentHandler(false);
    }

    public ContentHandler getInputContentHandler(boolean doDocFrag) {
        if (this.m_inputContentHandler == null) {
            this.m_inputContentHandler = new SourceTreeHandler(this, doDocFrag);
            ((SourceTreeHandler)this.m_inputContentHandler).setUseMultiThreading(true);
        }
        return this.m_inputContentHandler;
    }

    public DeclHandler getInputDeclHandler() {
        if (this.m_inputContentHandler instanceof DeclHandler) {
            return (DeclHandler)((Object)this.m_inputContentHandler);
        }
        return null;
    }

    public LexicalHandler getInputLexicalHandler() {
        if (this.m_inputContentHandler instanceof LexicalHandler) {
            return (LexicalHandler)((Object)this.m_inputContentHandler);
        }
        return null;
    }

    public KeyManager getKeyManager() {
        return this.m_keyManager;
    }

    public Node getMatchedNode() {
        return this.m_currentMatchTemplates.peepTail();
    }

    public ElemTemplate getMatchedTemplate() {
        return (ElemTemplate)this.m_currentMatchTemplates.peepTailSub1();
    }

    public MsgMgr getMsgMgr() {
        if (this.m_msgMgr == null) {
            this.m_msgMgr = new MsgMgr(this);
        }
        return this.m_msgMgr;
    }

    public OutputProperties getOutputFormat() {
        OutputProperties format = this.m_outputFormat == null ? this.getStylesheet().getOutputComposed() : this.m_outputFormat;
        return format;
    }

    public Properties getOutputProperties() {
        return (Properties)((Hashtable)this.getOutputFormat().getProperties()).clone();
    }

    public String getOutputProperty(String qnameString) throws IllegalArgumentException {
        String value = null;
        OutputProperties props = this.getOutputFormat();
        value = props.getProperty(qnameString);
        if (value == null && !props.isLegalPropertyKey(qnameString)) {
            throw new IllegalArgumentException("output property not recognized: " + qnameString);
        }
        return value;
    }

    public String getOutputPropertyNoDefault(String qnameString) throws IllegalArgumentException {
        String value = null;
        OutputProperties props = this.getOutputFormat();
        value = (String)((Hashtable)props.getProperties()).get(qnameString);
        if (value == null && !props.isLegalPropertyKey(qnameString)) {
            throw new IllegalArgumentException("output property not recognized: " + qnameString);
        }
        return value;
    }

    public Object getParameter(String name) {
        try {
            QName qname = QName.getQNameFromString(name);
            if (this.m_userParams == null) {
                return null;
            }
            int n = this.m_userParams.size();
            int i = n - 1;
            while (i >= 0) {
                Arg arg = (Arg)this.m_userParams.elementAt(i);
                if (arg.getQName().equals(qname)) {
                    return arg.getVal().object();
                }
                --i;
            }
            return null;
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    public boolean getQuietConflictWarnings() {
        return this.m_quietConflictWarnings;
    }

    public int getRecursionLimit() {
        return this.m_stackGuard.getRecursionLimit();
    }

    public ResultTreeHandler getResultTreeHandler() {
        return this.m_resultTreeHandler;
    }

    public Serializer getSerializer() {
        return this.m_serializer;
    }

    public StackGuard getStackGuard() {
        return this.m_stackGuard;
    }

    public ObjectPool getStringWriterPool() {
        return this.m_stringWriterObjectPool;
    }

    public StylesheetRoot getStylesheet() {
        return this.m_stylesheetRoot;
    }

    public TraceManager getTraceManager() {
        return this.m_traceManager;
    }

    public Thread getTransformThread() {
        return this.m_transformThread;
    }

    public Transformer getTransformer() {
        return this;
    }

    public URIResolver getURIResolver() {
        return this.getXPathContext().getSourceTreeManager().getURIResolver();
    }

    public XPathContext getXPathContext() {
        return this.m_xcontext;
    }

    public boolean isParserEventsOnMain() {
        return this.m_parserEventsOnMain;
    }

    public boolean isRecursiveAttrSet(ElemAttributeSet attrSet) {
        int loc;
        if (this.m_attrSetStack == null) {
            this.m_attrSetStack = new Stack();
        }
        return !this.m_attrSetStack.empty() && (loc = this.m_attrSetStack.search(attrSet)) > -1;
    }

    public boolean isTransformDone() {
        TransformerImpl transformerImpl = this;
        synchronized (transformerImpl) {
            boolean bl = this.m_isTransformDone;
            Object var3_3 = null;
            return bl;
        }
    }

    public Node parseToNode(Source source) throws TransformerException {
        if (source instanceof DOMSource) {
            return ((DOMSource)source).getNode();
        }
        InputSource xmlSource = SAXSource.sourceToInputSource(source);
        if (xmlSource == null) {
            throw new TransformerException("Can't transform a Source of type " + source.getClass().getName() + "!");
        }
        if (xmlSource.getSystemId() != null) {
            this.m_urlOfSource = xmlSource.getSystemId();
        }
        Node doc = null;
        try {
            XMLReader reader = null;
            if (source instanceof SAXSource) {
                reader = ((SAXSource)source).getXMLReader();
            }
            if (reader == null) {
                try {
                    SAXParserFactory factory = SAXParserFactory.newInstance();
                    factory.setNamespaceAware(true);
                    SAXParser jaxpParser = factory.newSAXParser();
                    reader = jaxpParser.getXMLReader();
                }
                catch (ParserConfigurationException ex) {
                    throw new SAXException(ex);
                }
                catch (FactoryConfigurationError ex1) {
                    throw new SAXException(ex1.toString());
                }
                catch (NoSuchMethodError noSuchMethodError) {
                }
                catch (AbstractMethodError abstractMethodError) {}
            }
            if (reader == null) {
                reader = XMLReaderFactory.createXMLReader();
            }
            try {
                reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
                reader.setFeature("http://apache.org/xml/features/validation/dynamic", true);
            }
            catch (SAXException sAXException) {}
            ContentHandler inputHandler = this.getInputContentHandler();
            Class<?> inputHandlerClass = inputHandler.getClass();
            inputHandler = (ContentHandler)inputHandlerClass.newInstance();
            reader.setContentHandler(inputHandler);
            if (inputHandler instanceof DTDHandler) {
                reader.setDTDHandler((DTDHandler)((Object)inputHandler));
            }
            try {
                if (inputHandler instanceof LexicalHandler) {
                    reader.setProperty("http://xml.org/sax/properties/lexical-handler", inputHandler);
                }
                if (inputHandler instanceof DeclHandler) {
                    reader.setProperty("http://xml.org/sax/properties/declaration-handler", inputHandler);
                }
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {}
            try {
                if (inputHandler instanceof LexicalHandler) {
                    reader.setProperty("http://xml.org/sax/handlers/LexicalHandler", inputHandler);
                }
                if (inputHandler instanceof DeclHandler) {
                    reader.setProperty("http://xml.org/sax/handlers/DeclHandler", inputHandler);
                }
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {}
            this.getXPathContext().setPrimaryReader(reader);
            if (inputHandler instanceof SourceTreeHandler) {
                reader.parse(xmlSource);
                doc = ((SourceTreeHandler)inputHandler).getRoot();
            }
        }
        catch (IllegalAccessException iae) {
            throw new TransformerException(iae);
        }
        catch (InstantiationException ie) {
            throw new TransformerException(ie);
        }
        catch (SAXException se) {
            throw new TransformerException(se);
        }
        catch (IOException ioe) {
            throw new TransformerException(ioe);
        }
        return doc;
    }

    public void popCurrentMatched() {
        this.m_currentMatchTemplates.popPair();
    }

    public void popCurrentTemplateRuleIsNull() {
        this.m_currentTemplateRuleIsNull.pop();
    }

    public void popElemAttributeSet() {
        this.m_attrSetStack.pop();
    }

    public void popElemTemplateElement() {
        this.m_currentTemplateElements.pop();
    }

    void postExceptionFromThread(Exception e) {
        ContentHandler ch;
        if (this.m_inputContentHandler instanceof SourceTreeHandler) {
            SourceTreeHandler sth = (SourceTreeHandler)this.m_inputContentHandler;
            sth.setExceptionThrown(e);
        }
        if ((ch = this.getContentHandler()) instanceof SourceTreeHandler) {
            SourceTreeHandler sth = (SourceTreeHandler)ch;
            ((TransformerImpl)sth.getTransformer()).postExceptionFromThread(e);
        }
        this.m_isTransformDone = true;
        this.m_exceptionThrown = e;
        TransformerImpl transformerImpl = this;
        synchronized (transformerImpl) {
            String msg = e.getMessage();
            this.notifyAll();
            if (msg == null) {
                e.printStackTrace();
            }
        }
    }

    public Vector processSortKeys(ElemForEach foreach, Node sourceNodeContext) throws TransformerException {
        Vector<NodeSortKey> keys = null;
        XPathContext xctxt = this.getXPathContext();
        int nElems = foreach.getSortElemCount();
        if (nElems > 0) {
            keys = new Vector<NodeSortKey>();
        }
        int i = 0;
        while (i < nElems) {
            boolean caseOrderUpper;
            ElemSort sort = foreach.getSortElem(i);
            String langString = sort.getLang() != null ? sort.getLang().evaluate(xctxt, sourceNodeContext, foreach) : null;
            String dataTypeString = sort.getDataType().evaluate(xctxt, sourceNodeContext, foreach);
            if (dataTypeString.indexOf(":") >= 0) {
                System.out.println("TODO: Need to write the hooks for QNAME sort data type");
            } else if (!dataTypeString.equalsIgnoreCase("text") && !dataTypeString.equalsIgnoreCase("number")) {
                foreach.error(93, new Object[]{"data-type", dataTypeString});
            }
            boolean treatAsNumbers = dataTypeString != null && dataTypeString.equals("number");
            String orderString = sort.getOrder().evaluate(xctxt, sourceNodeContext, foreach);
            if (!orderString.equalsIgnoreCase("ascending") && !orderString.equalsIgnoreCase("descending")) {
                foreach.error(93, new Object[]{"order", orderString});
            }
            boolean descending = orderString != null && orderString.equals("descending");
            AVT caseOrder = sort.getCaseOrder();
            if (caseOrder != null) {
                String caseOrderString = caseOrder.evaluate(xctxt, sourceNodeContext, foreach);
                if (!caseOrderString.equalsIgnoreCase("upper-first") && !caseOrderString.equalsIgnoreCase("lower-first")) {
                    foreach.error(93, new Object[]{"case-order", caseOrderString});
                }
                caseOrderUpper = caseOrderString != null && caseOrderString.equals("upper-first");
            } else {
                caseOrderUpper = false;
            }
            keys.addElement(new NodeSortKey(this, sort.getSelect(), treatAsNumbers, descending, langString, caseOrderUpper, foreach));
            ++i;
        }
        return keys;
    }

    public void pushCurrentTemplateRuleIsNull(boolean b) {
        this.m_currentTemplateRuleIsNull.push(b);
    }

    public void pushElemAttributeSet(ElemAttributeSet attrSet) {
        this.m_attrSetStack.push(attrSet);
    }

    public void pushElemTemplateElement(ElemTemplateElement elem) {
        this.m_currentTemplateElements.push(elem);
    }

    protected void pushGlobalVars(Node contextNode) throws TransformerException {
        XPathContext xctxt = this.getXPathContext();
        VariableStack vs = xctxt.getVarStack();
        StylesheetRoot sr = this.getStylesheet();
        Vector vars = sr.getVariablesAndParamsComposed();
        int startGlobals = vs.size();
        int i = vars.size();
        while (--i >= 0) {
            ElemVariable v = (ElemVariable)vars.elementAt(i);
            if (vs.variableIsDeclared(v.getName())) continue;
            XUnresolvedVariable xobj = new XUnresolvedVariable(v, contextNode, this, vs.getSearchStartOrTop(), 0, true);
            vs.pushVariable(v.getName(), xobj);
            vs.markGlobalStackFrame();
        }
        vs.markGlobalStackFrame();
        int endGlobals = vs.size();
        i = startGlobals;
        while (i < endGlobals) {
            Arg arg = (Arg)vs.elementAt(i);
            XUnresolvedVariable uv = (XUnresolvedVariable)arg.getVal();
            uv.setVarStackPos(endGlobals);
            ++i;
        }
        vs.pushContextMarker();
    }

    public void pushPairCurrentMatched(ElemTemplateElement template, Node child) {
        this.m_currentMatchTemplates.pushPair(template, child);
    }

    public void pushParams(XPathContext xctxt, ElemCallTemplate xslCallTemplateElement, Node sourceNode, QName mode) throws TransformerException {
        VariableStack vars = xctxt.getVarStack();
        int n = xslCallTemplateElement.getParamElemCount();
        int paramDeclareContext = vars.getSearchStartOrTop();
        vars.pushContextMarker();
        int paramReferenceContext = -1;
        int i = 0;
        while (i < n) {
            XObject var;
            vars.setSearchStart(paramDeclareContext);
            ElemWithParam xslParamElement = xslCallTemplateElement.getParamElem(i);
            XPath param = xslParamElement.getSelect();
            if (param != null) {
                var = param.execute(this.getXPathContext(), sourceNode, xslParamElement);
            } else if (xslParamElement.getFirstChild() == null) {
                var = XString.EMPTYSTRING;
            } else {
                DocumentFragment df = this.transformToRTF(xslParamElement, sourceNode, mode);
                var = new XRTreeFrag(df);
            }
            vars.setSearchStart(paramReferenceContext);
            vars.pushVariableArg(new Arg(xslParamElement.getName(), var, true));
            ++i;
        }
    }

    private void replaceOrPushUserParam(QName qname, XObject xval) {
        int n = this.m_userParams.size();
        int i = n - 1;
        while (i >= 0) {
            Arg arg = (Arg)this.m_userParams.elementAt(i);
            if (arg.getQName().equals(qname)) {
                this.m_userParams.setElementAt(new Arg(qname, xval, true), i);
                return;
            }
            --i;
        }
        this.m_userParams.addElement(new Arg(qname, xval, true));
    }

    public void reset() {
        if (!this.m_hasBeenReset) {
            this.m_hasBeenReset = true;
            if (this.m_outputStream != null) {
                try {
                    this.m_outputStream.close();
                }
                catch (IOException iOException) {}
            }
            this.m_outputStream = null;
            this.m_countersTable = null;
            this.m_stackGuard = new StackGuard();
            this.getXPathContext().reset();
            this.getXPathContext().getVarStack().setSize(1);
            this.m_currentTemplateElements.removeAllElements();
            this.m_currentMatchTemplates.removeAllElements();
            this.m_resultTreeHandler = null;
            this.m_keyManager = new KeyManager();
            this.m_attrSetStack = null;
            this.m_countersTable = null;
            this.m_currentTemplateRuleIsNull = new BoolStack();
            this.m_xmlSource = null;
            this.m_doc = null;
            this.m_isTransformDone = false;
            this.m_inputContentHandler = null;
            this.getXPathContext().getSourceTreeManager().reset();
        }
    }

    public void run() {
        block12: {
            this.m_hasBeenReset = false;
            try {
                if (this.isParserEventsOnMain()) {
                    TransformerImpl transformerImpl;
                    try {
                        try {
                            this.m_isTransformDone = false;
                            this.transformNode(this.m_doc);
                        }
                        catch (Exception e) {
                            this.postExceptionFromThread(e);
                        }
                        Object var2_4 = null;
                        this.m_isTransformDone = true;
                        transformerImpl = this;
                    }
                    catch (Throwable throwable) {
                        Object var2_5 = null;
                        this.m_isTransformDone = true;
                        TransformerImpl transformerImpl2 = this;
                        synchronized (transformerImpl2) {
                            this.notifyAll();
                        }
                        throw throwable;
                    }
                    synchronized (transformerImpl) {
                        this.notifyAll();
                        break block12;
                    }
                }
                InputSource isource = SAXSource.sourceToInputSource(this.m_xmlSource);
                this.getXPathContext().getPrimaryReader().parse(isource);
            }
            catch (Exception e) {
                this.postExceptionFromThread(e);
            }
        }
    }

    public void setBaseURLOfSource(String base) {
        this.m_urlOfSource = base;
    }

    public void setContentHandler(ContentHandler handler) {
        if (handler == null) {
            throw new NullPointerException("Null content handler");
        }
        this.m_outputContentHandler = handler;
        if (this.m_resultTreeHandler == null) {
            this.m_resultTreeHandler = new ResultTreeHandler(this, handler);
        } else {
            this.m_resultTreeHandler.setContentHandler(handler);
        }
    }

    public void setCurrentElement(ElemTemplateElement e) {
        this.m_currentTemplateElements.setTail(e);
    }

    public void setErrorListener(ErrorListener listener) throws IllegalArgumentException {
        Boolean bl = this.m_reentryGuard;
        synchronized (bl) {
            if (listener == null) {
                throw new IllegalArgumentException("Null error handler");
            }
            this.m_errorHandler = listener;
        }
    }

    public void setOutputFormat(OutputProperties oformat) {
        this.m_outputFormat = oformat;
    }

    public void setOutputProperties(Properties oformat) {
        Boolean bl = this.m_reentryGuard;
        synchronized (bl) {
            if (oformat != null) {
                String method = (String)((Hashtable)oformat).get("method");
                this.m_outputFormat = method != null ? new OutputProperties(method) : new OutputProperties();
            }
            if (oformat != null) {
                this.m_outputFormat.copyFrom(oformat);
            }
            this.m_outputFormat.copyFrom(this.m_stylesheetRoot.getOutputProperties());
        }
    }

    public void setOutputProperty(String name, String value) throws IllegalArgumentException {
        Boolean bl = this.m_reentryGuard;
        synchronized (bl) {
            if (this.m_outputFormat == null) {
                this.m_outputFormat = (OutputProperties)this.getStylesheet().getOutputComposed().clone();
            }
            if (!this.m_outputFormat.isLegalPropertyKey(name)) {
                throw new IllegalArgumentException("output property not recognized: " + name);
            }
            this.m_outputFormat.setProperty(name, value);
        }
    }

    public void setParameter(String name, Object value) {
        StringTokenizer tokenizer = new StringTokenizer(name, "{}", false);
        try {
            String s2;
            String s1 = tokenizer.nextToken();
            String string = s2 = tokenizer.hasMoreTokens() ? tokenizer.nextToken() : null;
            if (this.m_userParams == null) {
                this.m_userParams = new Vector();
            }
            if (s2 == null) {
                this.replaceOrPushUserParam(new QName(s1), new XObject(value));
                this.setParameter(s1, null, value);
            } else {
                this.replaceOrPushUserParam(new QName(s1, s2), new XObject(value));
                this.setParameter(s2, s1, value);
            }
        }
        catch (NoSuchElementException noSuchElementException) {}
    }

    public void setParameter(String name, String namespace, Object value) {
        VariableStack varstack = this.getXPathContext().getVarStack();
        QName qname = new QName(namespace, name);
        XObject xobject = XObject.create(value);
        varstack.pushOrReplaceVariable(qname, xobject);
    }

    public void setParameters(Properties params) {
        this.clearParameters();
        Enumeration<?> names = params.propertyNames();
        while (names.hasMoreElements()) {
            String name = params.getProperty((String)names.nextElement());
            StringTokenizer tokenizer = new StringTokenizer(name, "{}", false);
            try {
                String s2;
                String s1 = tokenizer.nextToken();
                String string = s2 = tokenizer.hasMoreTokens() ? tokenizer.nextToken() : null;
                if (s2 == null) {
                    this.setParameter(s1, null, params.getProperty(name));
                    continue;
                }
                this.setParameter(s2, s1, params.getProperty(name));
            }
            catch (NoSuchElementException noSuchElementException) {}
        }
    }

    public void setQuietConflictWarnings(boolean b) {
        this.m_quietConflictWarnings = b;
    }

    public void setRecursionLimit(int limit) {
        this.m_stackGuard.setRecursionLimit(limit);
    }

    public void setSerializer(Serializer s) {
        this.m_serializer = s;
    }

    public void setSourceTreeDocForThread(Node doc) {
        this.m_doc = doc;
    }

    public void setStylesheet(StylesheetRoot stylesheetRoot) {
        this.m_stylesheetRoot = stylesheetRoot;
    }

    public void setTransformThread(Thread t) {
        this.m_transformThread = t;
    }

    public void setURIResolver(URIResolver resolver) {
        Boolean bl = this.m_reentryGuard;
        synchronized (bl) {
            this.getXPathContext().getSourceTreeManager().setURIResolver(resolver);
        }
    }

    public void setXPathContext(XPathContext xcontext) {
        this.m_xcontext = xcontext;
    }

    /*
     * Unable to fully structure code
     */
    public void transform(Source source) throws TransformerException {
        if (source instanceof DOMSource) {
            dsource = (DOMSource)source;
            this.m_urlOfSource = dsource.getSystemId();
            dNode = dsource.getNode();
            if (dNode != null) {
                if (this.m_urlOfSource != null) {
                    this.getXPathContext().getSourceTreeManager().putDocumentInCache(dNode, dsource);
                }
                this.transformNode(dsource.getNode());
                return;
            }
            messageStr = XSLMessages.createMessage(108, null);
            throw new IllegalArgumentException(messageStr);
        }
        xmlSource = SAXSource.sourceToInputSource(source);
        if (xmlSource == null) {
            throw new TransformerException("Can't transform a Source of type " + source.getClass().getName() + "!");
        }
        if (xmlSource.getSystemId() != null) {
            this.m_urlOfSource = xmlSource.getSystemId();
        }
        try {
            try {
                reader = null;
                if (source instanceof SAXSource) {
                    reader = ((SAXSource)source).getXMLReader();
                }
                if (reader == null) {
                    try {
                        factory = SAXParserFactory.newInstance();
                        factory.setNamespaceAware(true);
                        jaxpParser = factory.newSAXParser();
                        reader = jaxpParser.getXMLReader();
                    }
                    catch (ParserConfigurationException ex) {
                        throw new SAXException(ex);
                    }
                    catch (FactoryConfigurationError ex1) {
                        throw new SAXException(ex1.toString());
                    }
                    catch (NoSuchMethodError v0) {
                    }
                    catch (AbstractMethodError v1) {}
                }
                if (reader == null) {
                    reader = XMLReaderFactory.createXMLReader();
                }
                try {
                    reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
                    reader.setFeature("http://apache.org/xml/features/validation/dynamic", true);
                }
                catch (SAXException v2) {}
                inputHandler = this.getInputContentHandler();
                reader.setContentHandler(inputHandler);
                if (inputHandler instanceof DTDHandler) {
                    reader.setDTDHandler((DTDHandler)inputHandler);
                }
                try {
                    if (inputHandler instanceof LexicalHandler) {
                        reader.setProperty("http://xml.org/sax/properties/lexical-handler", inputHandler);
                    }
                    if (inputHandler instanceof DeclHandler) {
                        reader.setProperty("http://xml.org/sax/properties/declaration-handler", inputHandler);
                    }
                }
                catch (SAXException v3) {}
                try {
                    if (inputHandler instanceof LexicalHandler) {
                        reader.setProperty("http://xml.org/sax/handlers/LexicalHandler", inputHandler);
                    }
                    if (inputHandler instanceof DeclHandler) {
                        reader.setProperty("http://xml.org/sax/handlers/DeclHandler", inputHandler);
                    }
                }
                catch (SAXNotRecognizedException v4) {}
                this.getXPathContext().setPrimaryReader(reader);
                this.m_exceptionThrown = null;
                if (inputHandler instanceof SourceTreeHandler) {
                    sth = (SourceTreeHandler)inputHandler;
                    sth.setInputSource(source);
                    sth.setUseMultiThreading(true);
                    doc = sth.getRoot();
                    if (doc != null) {
                        stm = this.getXPathContext().getSourceTreeManager();
                        stm.putDocumentInCache(doc, source);
                        this.m_xmlSource = source;
                        this.m_doc = doc;
                        if (this.isParserEventsOnMain()) {
                            this.m_isTransformDone = false;
                            this.getXPathContext().getPrimaryReader().parse(xmlSource);
                        } else {
                            t = this.createTransformThread();
                            t.start();
                            this.transformNode(doc);
                        }
                    }
                } else {
                    reader.parse(xmlSource);
                }
                if ((e = this.getExceptionThrown()) != null) {
                    if (e instanceof TransformerException) {
                        throw (TransformerException)e;
                    }
                    if (e instanceof WrappedRuntimeException) {
                        throw new TransformerException(((WrappedRuntimeException)e).getException());
                    }
                    throw new TransformerException(e);
                }
                if (this.m_resultTreeHandler != null) {
                    this.m_resultTreeHandler.endDocument();
                }
            }
            catch (WrappedRuntimeException wre) {
                throwable = wre.getException();
                ** while (throwable instanceof WrappedRuntimeException)
            }
lbl-1000:
            // 1 sources

            {
                throwable = ((WrappedRuntimeException)throwable).getException();
                continue;
            }
lbl97:
            // 1 sources

            throw new TransformerException(wre.getException());
            catch (SAXParseException spe) {
                msg = spe.getMessage();
                loc = new SAXSourceLocator(spe);
                this.m_errorHandler.fatalError(new TransformerException(msg, loc));
            }
            catch (SAXException se) {
                this.m_errorHandler.fatalError(new TransformerException(se));
            }
            catch (IOException ioe) {
                this.m_errorHandler.fatalError(new TransformerException(ioe));
            }
            var4_7 = null;
            this.reset();
        }
        catch (Throwable var3_5) {
            var4_8 = null;
            this.reset();
            throw var3_5;
        }
    }

    public void transform(Source xmlSource, Result outputTarget) throws TransformerException {
        Boolean bl = this.m_reentryGuard;
        synchronized (bl) {
            ContentHandler handler = this.createResultContentHandler(outputTarget);
            this.setContentHandler(handler);
            this.transform(xmlSource);
        }
    }

    public void transformNode(Node node) throws TransformerException {
        ContentHandler contentHandler = this.m_outputContentHandler;
        synchronized (contentHandler) {
            this.m_hasBeenReset = false;
            try {
                try {
                    this.pushGlobalVars(node);
                    StylesheetRoot stylesheet = this.getStylesheet();
                    int n = stylesheet.getGlobalImportCount();
                    int i = 0;
                    while (i < n) {
                        StylesheetComposed imported = stylesheet.getGlobalImport(i);
                        int includedCount = imported.getIncludeCountComposed();
                        int j = -1;
                        while (j < includedCount) {
                            Stylesheet included = imported.getIncludeComposed(j);
                            included.runtimeInit(this);
                            ElemTemplateElement child = included.getFirstChildElem();
                            while (child != null) {
                                child.runtimeInit(this);
                                child = child.getNextSiblingElem();
                            }
                            ++j;
                        }
                        ++i;
                    }
                    this.applyTemplateToNode(null, null, node, null);
                    if (this.m_resultTreeHandler != null) {
                        this.m_resultTreeHandler.endDocument();
                    }
                }
                catch (Exception se) {
                    if (this.m_resultTreeHandler != null) {
                        try {
                            this.m_resultTreeHandler.endDocument();
                        }
                        catch (Exception exception) {}
                    }
                    throw new TransformerException(se.getMessage(), se);
                }
                Object var5_12 = null;
                this.reset();
            }
            catch (Throwable throwable) {
                Object var5_13 = null;
                this.reset();
                throw throwable;
            }
        }
    }

    public void transformNode(Node node, Result outputTarget) throws TransformerException {
        ContentHandler handler = this.createResultContentHandler(outputTarget);
        this.setContentHandler(handler);
        this.transformNode(node);
    }

    public DocumentFragment transformToRTF(ElemTemplateElement templateParent, Node sourceNode, QName mode) throws TransformerException {
        DocumentFragment resultFragment;
        ContentHandler rtfHandler;
        boolean isSTree = sourceNode instanceof Child;
        if (isSTree) {
            rtfHandler = new SourceTreeHandler(this, true);
            rtfHandler.setUseMultiThreading(false);
            rtfHandler.setShouldTransformAtEnd(false);
            resultFragment = (DocumentFragment)rtfHandler.getRoot();
        } else {
            if (this.m_docBuilder == null) {
                try {
                    DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
                    dfactory.setNamespaceAware(true);
                    dfactory.setValidating(true);
                    this.m_docBuilder = dfactory.newDocumentBuilder();
                }
                catch (ParserConfigurationException pce) {
                    throw new TransformerException(pce);
                }
            }
            Document docFactory = this.m_docBuilder.newDocument();
            resultFragment = docFactory.createDocumentFragment();
            rtfHandler = new DOMBuilder(docFactory, resultFragment);
        }
        ResultTreeHandler savedRTreeHandler = this.m_resultTreeHandler;
        this.m_resultTreeHandler = new ResultTreeHandler(this, rtfHandler);
        try {
            try {
                this.m_resultTreeHandler.startDocument();
                this.executeChildTemplates(templateParent, sourceNode, mode);
                this.m_resultTreeHandler.flushPending();
                this.m_resultTreeHandler.endDocument();
            }
            catch (SAXException se) {
                throw new TransformerException(se);
            }
            Object var9_10 = null;
            this.m_resultTreeHandler = savedRTreeHandler;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            this.m_resultTreeHandler = savedRTreeHandler;
            throw throwable;
        }
        return resultFragment;
    }

    public String transformToString(ElemTemplateElement elem, Node sourceNode, QName mode) throws TransformerException {
        String result;
        ResultTreeHandler savedRTreeHandler = this.m_resultTreeHandler;
        StringWriter sw = (StringWriter)this.m_stringWriterObjectPool.getInstance();
        this.m_resultTreeHandler = (ResultTreeHandler)this.m_textResultHandlerObjectPool.getInstance();
        Serializer serializer = this.m_resultTreeHandler.getSerializer();
        try {
            if (serializer == null) {
                serializer = SerializerFactory.getSerializer(this.m_textformat.getProperties());
                this.m_resultTreeHandler.setSerializer(serializer);
                serializer.setWriter(sw);
                ContentHandler shandler = serializer.asContentHandler();
                this.m_resultTreeHandler.init(this, shandler);
            }
        }
        catch (IOException ioe) {
            throw new TransformerException(ioe);
        }
        try {
            try {
                this.m_resultTreeHandler.startDocument();
                this.executeChildTemplates(elem, sourceNode, mode);
                this.m_resultTreeHandler.endDocument();
                result = sw.toString();
            }
            catch (SAXException se) {
                throw new TransformerException(se);
            }
            Object var9_10 = null;
            sw.getBuffer().setLength(0);
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            sw.getBuffer().setLength(0);
            try {
                sw.close();
            }
            catch (Exception exception) {}
            this.m_stringWriterObjectPool.freeInstance(sw);
            this.m_textResultHandlerObjectPool.freeInstance(this.m_resultTreeHandler);
            this.m_resultTreeHandler.reset();
            this.m_resultTreeHandler = savedRTreeHandler;
            throw throwable;
        }
        try {
            sw.close();
        }
        catch (Exception exception) {}
        this.m_stringWriterObjectPool.freeInstance(sw);
        this.m_textResultHandlerObjectPool.freeInstance(this.m_resultTreeHandler);
        this.m_resultTreeHandler.reset();
        this.m_resultTreeHandler = savedRTreeHandler;
        return result;
    }
}

