/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.utils;

import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DefaultErrorHandler
implements ErrorHandler,
ErrorListener {
    public void error(TransformerException exception) throws TransformerException {
        this.printLocation(exception);
        throw exception;
    }

    public void error(SAXParseException exception) throws SAXException {
        this.printLocation(exception);
        throw exception;
    }

    public void fatalError(TransformerException exception) throws TransformerException {
        this.printLocation(exception);
        throw exception;
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        this.printLocation(exception);
        throw exception;
    }

    private void printLocation(TransformerException exception) {
        SourceLocator locator = exception.getLocator();
        if (locator != null) {
            String id = locator.getPublicId() != locator.getPublicId() ? locator.getPublicId() : (locator.getSystemId() != null ? locator.getSystemId() : "SystemId Unknown");
            System.out.print(String.valueOf(id) + "; Line " + locator.getLineNumber() + "; Column " + locator.getColumnNumber() + "; ");
        }
    }

    private void printLocation(SAXParseException exception) {
        String id = exception.getSystemId() != null ? exception.getSystemId() : "SystemId Unknown";
        System.out.print(String.valueOf(id) + "; Line " + exception.getLineNumber() + "; Column " + exception.getColumnNumber() + "; ");
    }

    public void warning(TransformerException exception) throws TransformerException {
        this.printLocation(exception);
        System.out.println(exception.getMessage());
    }

    public void warning(SAXParseException exception) throws SAXException {
        this.printLocation(exception);
        System.out.println("Parser warning: " + exception.getMessage());
    }
}

