/*
 * Decompiled with CFR 0.152.
 */
package phex;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.rmi.dgc.VMID;
import phex.ServiceManager;
import phex.utils.HexDec;

public class GUID
implements Serializable {
    public static final int sDataLength = 16;
    private byte[] mBytes;
    private Integer mHashCode = new Integer(0);
    private String mStr = null;

    public GUID() {
        VMID vMID = new VMID();
        this.mBytes = new byte[16];
        this.vmid2GUID(vMID.toString());
        this.computeHashCode();
    }

    public GUID(boolean bl) {
        this.mBytes = new byte[16];
    }

    public GUID(byte[] byArray) {
        this.mBytes = byArray;
        this.mStr = null;
        this.computeHashCode();
    }

    public void setGuid(byte[] byArray) {
        System.arraycopy(byArray, 0, this.mBytes, 0, 16);
        this.mStr = null;
        this.computeHashCode();
    }

    public byte[] getGuid() {
        return this.mBytes;
    }

    public Integer getHashCode() {
        return this.mHashCode;
    }

    public boolean equals(GUID gUID) {
        for (int i = 0; i < 16; ++i) {
            if (this.mBytes[i] == gUID.mBytes[i]) continue;
            return false;
        }
        return true;
    }

    private void computeHashCode() {
        int n = this.mBytes[0] < 0 ? this.mBytes[0] + 256 : this.mBytes[0];
        int n2 = this.mBytes[1] < 0 ? this.mBytes[1] + 256 : this.mBytes[1];
        int n3 = this.mBytes[2] < 0 ? this.mBytes[2] + 256 : this.mBytes[2];
        int n4 = this.mBytes[3] < 0 ? this.mBytes[3] + 256 : this.mBytes[3];
        int n5 = n << 24 | n2 << 16 | n3 << 8 | n4;
        for (int i = 4; i < 16; i += 4) {
            n = this.mBytes[i + 0] < 0 ? this.mBytes[i + 0] + 256 : this.mBytes[i + 0];
            n2 = this.mBytes[i + 1] < 0 ? this.mBytes[i + 1] + 256 : this.mBytes[i + 1];
            n3 = this.mBytes[i + 2] < 0 ? this.mBytes[i + 2] + 256 : this.mBytes[i + 2];
            n4 = this.mBytes[i + 3] < 0 ? this.mBytes[i + 3] + 256 : this.mBytes[i + 3];
            int n6 = n << 24 | n2 << 16 | n3 << 8 | n4;
            n5 ^= n6;
        }
        this.mHashCode = new Integer(n5);
    }

    public int getSize() {
        return 16;
    }

    public void copy(byte[] byArray) {
        System.arraycopy(byArray, 0, this.mBytes, 0, 16);
        this.mStr = null;
        this.computeHashCode();
    }

    public int serialize(byte[] byArray, int n) {
        System.arraycopy(this.mBytes, 0, byArray, n, 16);
        return n + 16;
    }

    public int deserialize(byte[] byArray, int n) {
        System.arraycopy(byArray, n, this.mBytes, 0, 16);
        this.mStr = null;
        this.computeHashCode();
        return n + 16;
    }

    private void vmid2GUID(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (i < 16) {
                this.mBytes[n] = (byte)string.charAt(i);
            } else {
                int n2 = n;
                this.mBytes[n2] = (byte)(this.mBytes[n2] ^ (byte)string.charAt(i));
            }
            if (++n < 16) continue;
            n = 0;
        }
        this.mStr = null;
        this.mBytes[8] = -1;
        this.mBytes[15] = 0;
    }

    public String toString() {
        if (this.mStr == null) {
            this.mStr = this.generateString();
        }
        return this.mStr;
    }

    private String generateString() {
        String string = "";
        string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(HexDec.convertBytesToHexString(this.mBytes, 0, 4))).concat("-"))));
        string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(HexDec.convertBytesToHexString(this.mBytes, 4, 2))).concat("-"))));
        string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(HexDec.convertBytesToHexString(this.mBytes, 6, 2))).concat("-"))));
        string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(HexDec.convertBytesToHexString(this.mBytes, 8, 2))).concat("-"))));
        string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(HexDec.convertBytesToHexString(this.mBytes, 10, 6))));
        return string;
    }

    public String toHexString() {
        return HexDec.convertBytesToHexString(this.mBytes);
    }

    public void fromHexString(String string) throws Exception {
        this.mBytes = HexDec.convertHexStringToBytes(string);
        this.mStr = null;
        this.computeHashCode();
    }

    public void readFromOIS(DataInputStream dataInputStream, boolean bl) throws ClassNotFoundException, IOException {
        if (bl) {
            dataInputStream.skipBytes(67);
        } else {
            if (dataInputStream.readByte() == 113) {
                ServiceManager.log("found known GUID class: skipping");
                dataInputStream.skipBytes(3);
                return;
            }
            dataInputStream.skipBytes(3);
        }
        byte[] byArray = new byte[]{dataInputStream.readByte(), dataInputStream.readByte(), dataInputStream.readByte(), dataInputStream.readByte()};
        ServiceManager.log(String.valueOf(String.valueOf(new StringBuffer("Reading GUID after: ").append(byArray[0]).append(" ").append(byArray[1]).append(" ").append(byArray[2]).append(" ").append(byArray[3]))));
        int n = dataInputStream.readInt();
        ServiceManager.log("Reading GUID Item: ".concat(String.valueOf(String.valueOf(n))));
        switch (n) {
            case 1: {
                this.deserialize1(dataInputStream, bl);
                break;
            }
            default: {
                throw new IOException("Fail to deserialize guid of datafile. Unknown verison.");
            }
        }
        this.mStr = null;
        this.computeHashCode();
        ServiceManager.log("Reading GUID: ".concat(String.valueOf(String.valueOf(this.toString()))));
        ServiceManager.log("Reading GUID: ".concat(String.valueOf(String.valueOf(this.toHexString()))));
    }

    private void deserialize1(DataInputStream dataInputStream, boolean bl) throws ClassNotFoundException, IOException {
        if (bl) {
            dataInputStream.skipBytes(23);
        } else {
            dataInputStream.skipBytes(10);
        }
        for (int i = 0; i < 16; ++i) {
            this.mBytes[i] = dataInputStream.readByte();
        }
    }

    public static GUID createFromHexString(String string) throws Exception {
        GUID gUID = new GUID(true);
        gUID.fromHexString(string);
        return gUID;
    }

    public static void main(String[] stringArray) {
        GUID gUID = new GUID();
        System.out.println(gUID);
    }
}

