/*
 * Decompiled with CFR 0.152.
 */
package phex;

import java.util.StringTokenizer;

public class HttpRange {
    protected int mCount = 0;
    protected int mMaxSize = 4;
    protected int[] mFirstPos = new int[this.mMaxSize];
    protected int[] mLastPos = new int[this.mMaxSize];
    protected int mEntitySize = 0;

    protected HttpRange() {
    }

    public HttpRange(int n) {
        this.mEntitySize = n;
    }

    public boolean deserialize(String string) {
        try {
            string = string.toLowerCase().trim();
            if (!string.startsWith("bytes")) {
                boolean bl = false;
                return bl;
            }
            string = string.substring(6);
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "-", true);
                String string3 = stringTokenizer2.nextToken();
                if (string3.equals("-")) {
                    int n = Integer.parseInt(stringTokenizer2.nextToken());
                    this.mFirstPos[this.mCount] = this.mEntitySize - n;
                    this.mLastPos[this.mCount] = this.mEntitySize - 1;
                } else {
                    this.mFirstPos[this.mCount] = Integer.parseInt(string3);
                    stringTokenizer2.nextToken();
                    this.mLastPos[this.mCount] = stringTokenizer2.hasMoreTokens() ? Integer.parseInt(stringTokenizer2.nextToken()) : this.mEntitySize - 1;
                }
                ++this.mCount;
            }
        }
        catch (Exception exception) {
            this.mCount = 0;
            boolean bl = false;
            return bl;
        }
        return true;
    }

    public String serialize() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Range: bytes=");
        for (int i = 0; i < this.mCount; ++i) {
            if (i > 0) {
                stringBuffer.append(",");
            }
            if (this.mFirstPos[i] >= 0) {
                stringBuffer.append(this.mFirstPos[i]);
            }
            stringBuffer.append("-");
            if (this.mLastPos[i] < 0) continue;
            stringBuffer.append(this.mLastPos[i]);
        }
        return stringBuffer.toString();
    }

    public void setSpec(int n, int n2, int n3) {
        this.mFirstPos[n] = n2;
        this.mLastPos[n] = n3;
    }

    public int addSpec(int n, int n2) {
        this.ensureSize(this.mCount + 1);
        this.mFirstPos[this.mCount] = n;
        this.mLastPos[this.mCount] = n2;
        ++this.mCount;
        return this.mCount - 1;
    }

    public int getSpecCount() {
        return this.mCount;
    }

    public void setSpecCount(int n) {
        this.mCount = n;
        this.ensureSize(n);
    }

    public int getFirstPos(int n) {
        return this.mFirstPos[n];
    }

    public int getLastPos(int n) {
        return this.mLastPos[n];
    }

    public int getFirstPos() {
        return this.mFirstPos[0];
    }

    public int getLastPos() {
        return this.mLastPos[0];
    }

    public int getEntitySize() {
        return this.mEntitySize;
    }

    public void setEntitySize(int n) {
        this.mEntitySize = n;
    }

    public String toString() {
        return this.serialize();
    }

    protected void ensureSize(int n) {
        if (this.mMaxSize < n) {
            int[] nArray = new int[n + 4];
            int[] nArray2 = new int[n + 4];
            System.arraycopy(this.mFirstPos, 0, nArray, 0, this.mCount);
            System.arraycopy(this.mLastPos, 0, nArray2, 0, this.mCount);
            this.mFirstPos = nArray;
            this.mLastPos = nArray2;
            this.mMaxSize = n + 4;
        }
    }

    public static void main(String[] stringArray) {
        HttpRange httpRange = new HttpRange(1000);
        httpRange.deserialize(stringArray[0]);
        System.out.println(httpRange);
    }
}

