/*
 * Decompiled with CFR 0.152.
 */
package phex;

import phex.MainFrame;
import phex.NetworkManager;
import phex.ServiceManager;
import phex.common.TransferRateService;
import phex.download.DownloadManager;
import phex.host.HostManager;
import phex.msg.MsgManager;
import phex.query.QueryManager;
import phex.share.ShareManager;
import phex.utils.StatisticTracker;

public class JobsRunner
implements Runnable {
    private boolean mRequestToDie = false;
    private boolean mRunning = false;
    private boolean mShutdownCompleted = false;
    private HostManager mHostMgr = ServiceManager.getHostManager();
    private NetworkManager mNetworkMgr = ServiceManager.getNetworkManager();
    private MsgManager mMsgManager = ServiceManager.getMsgManager();
    private DownloadManager mDownloadMgr = ServiceManager.getDownloadManager();
    private ShareManager mShareMgr = ServiceManager.getShareManager();
    private StatisticTracker statisticTracker = ServiceManager.getStatisticTracker();
    private TransferRateService transferRateService = ServiceManager.getTransferRateService();
    private boolean mInitScan = false;

    JobsRunner() {
    }

    public synchronized void startup() {
        if (this.mRunning) {
            return;
        }
        ServiceManager.log("Background jobs runner starting...");
        this.mRequestToDie = false;
        this.mRunning = true;
        new Thread((Runnable)this, "JobsRunner-".concat(String.valueOf(String.valueOf(Integer.toHexString(this.hashCode()))))).start();
    }

    public boolean getRunning() {
        return this.mRunning;
    }

    public synchronized void shutdown(boolean bl) {
        if (this.mRequestToDie) {
            return;
        }
        ServiceManager.log("Background jobs runner shutting down...");
        this.mShutdownCompleted = false;
        this.mRequestToDie = true;
        if (bl) {
            while (!this.mShutdownCompleted) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
        }
    }

    public void run() {
        ServiceManager.log("Background jobs runner started.");
        MainFrame mainFrame = ServiceManager.getManager().getMainFrame();
        int n = 1000;
        int n2 = 0;
        QueryManager queryManager = ServiceManager.getQueryManager();
        block4: while (true) {
            try {
                while (true) {
                    try {
                        Thread.sleep(n);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (this.mRequestToDie) break block4;
                    this.mMsgManager.pingNeighbors();
                    this.mHostMgr.periodicallyCheckHosts();
                    ServiceManager.getLazyEventQueue().fireLazyEvents();
                    if (n2 % 2 == 0) {
                        this.mHostMgr.cleanupConnectedHosts();
                        this.mHostMgr.cleanupNetworkHosts();
                        int n3 = this.mHostMgr.getConnectedHostCount();
                        if (n3 < ServiceManager.sCfg.mNetMinConn && this.mNetworkMgr.getJoined()) {
                            int n4;
                            for (int i = n4 = ServiceManager.sCfg.mNetMaxConnection - this.mHostMgr.getNetworkHostCount(); i > 0; --i) {
                                this.mHostMgr.autoConnectToNextCaughtHost();
                            }
                        }
                        this.mDownloadMgr.retryDownloads();
                    }
                    if (n2 % 5 == 0) {
                        mainFrame.getDownloadTab().removeCompletedDownloads();
                        if (ServiceManager.sCfg.mUploadAutoRemoveCompleted) {
                            this.mShareMgr.getUploadFileContainer().cleanUploadFileList();
                        }
                        queryManager.stopExpiredSearches();
                        queryManager.getResearchService().startResearchSequence();
                    }
                    if (n2 % 10 == 0) {
                        this.statisticTracker.newRateSamplePeriod();
                        this.transferRateService.setTransferRateTimestamp();
                    }
                    if (n2 % 60 == 0) {
                        this.mHostMgr.saveHostsContainer();
                    }
                    if (!this.mInitScan) {
                        this.mShareMgr.getFileAdministration().rescan();
                        this.mInitScan = true;
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
            break;
        }
        this.shutdownCompleted();
    }

    private synchronized void shutdownCompleted() {
        this.mRunning = false;
        ServiceManager.log("Background jobs runner stopped.");
        this.mShutdownCompleted = true;
        this.notifyAll();
    }
}

