/*
 * Decompiled with CFR 0.152.
 */
package phex;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import phex.ReadWorker;
import phex.ServiceManager;
import phex.host.Host;
import phex.host.HostAddress;
import phex.interfaces.IHostChanged;

public class Listener
implements Runnable {
    private InetAddress mMyIP;
    private ServerSocket mListeningSocket;
    private boolean mRequestToDie = false;
    private boolean mRunning = false;
    private boolean mShutdownCompleted = false;
    private IHostChanged mHostChangedListener = null;
    private boolean hasConnectedIncomming = false;
    private HostAddress localAddress;

    public Listener() {
        try {
            this.localAddress = new HostAddress(HostAddress.LOCAL_HOST_NAME, 6346);
            if (ServiceManager.sCfg.mMyIP.length() > 0) {
                this.mMyIP = InetAddress.getByName(ServiceManager.sCfg.mMyIP);
            }
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
        }
    }

    public synchronized void startup() throws IOException {
        boolean bl;
        if (this.mRunning) {
            return;
        }
        ServiceManager.getShareManager();
        ServiceManager.log("Listener starting...");
        int n = ServiceManager.sCfg.mListeningPort;
        int n2 = 0;
        do {
            bl = false;
            try {
                this.mListeningSocket = new ServerSocket(n, 50);
            }
            catch (BindException bindException) {
                if (n2 > 10) {
                    throw bindException;
                }
                bl = true;
                ++n;
                ++n2;
            }
        } while (bl);
        this.mRequestToDie = false;
        this.mRunning = true;
        n = this.mListeningSocket.getLocalPort();
        String string = this.resolveSelfHostName();
        this.localAddress.updateAddress(string, n);
        if (this.mHostChangedListener != null) {
            this.mHostChangedListener.updateMyIP();
        }
        new Thread((Runnable)this, "Listener-".concat(String.valueOf(String.valueOf(Integer.toHexString(this.hashCode()))))).start();
    }

    public synchronized void shutdown(boolean bl) {
        if (!this.mRunning || this.mRequestToDie) {
            return;
        }
        ServiceManager.log("Listener shutting down...");
        this.mShutdownCompleted = false;
        this.mRequestToDie = true;
        try {
            Socket socket = new Socket(HostAddress.LOCAL_HOST_NAME, this.localAddress.getPort());
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (bl) {
            while (!this.mShutdownCompleted) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
        }
    }

    protected boolean getRequestToDie() {
        return this.mRequestToDie;
    }

    public boolean getRunning() {
        return this.mRunning;
    }

    public void setSelfHostname(String string) {
        try {
            if (this.mMyIP == null) {
                this.localAddress.updateAddress(string, this.localAddress.getPort());
            } else {
                this.localAddress.updateAddress(this.mMyIP.getHostAddress(), this.localAddress.getPort());
            }
            if (this.mHostChangedListener != null) {
                this.mHostChangedListener.updateMyIP();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setMyIP(String string) {
        try {
            this.mMyIP = string.length() > 0 ? InetAddress.getByName(string) : null;
            this.setSelfHostname(this.localAddress.getHostName());
        }
        catch (Exception exception) {
            this.mMyIP = null;
        }
    }

    public HostAddress getLocalAddress() {
        return this.localAddress;
    }

    public boolean hasConnectedIncoming() {
        return this.hasConnectedIncomming;
    }

    public void setHostChangedListener(IHostChanged iHostChanged) {
        this.mHostChangedListener = iHostChanged;
    }

    public void run() {
        ServiceManager.log("Listener started.");
        while (true) {
            Socket socket;
            try {
                socket = this.mListeningSocket.accept();
                socket.setSoTimeout(ServiceManager.sCfg.mSocketTimeout);
                this.hasConnectedIncomming = true;
            }
            catch (IOException iOException) {
                ServiceManager.log(iOException.toString());
                break;
            }
            if (this.getRequestToDie()) break;
            try {
                HostAddress hostAddress = new HostAddress(socket.getInetAddress().getHostAddress(), socket.getPort());
                Host host = new Host(hostAddress);
                host.setType(2);
                host.setSock(socket);
                host.setOs(socket.getOutputStream());
                host.setIs(socket.getInputStream());
                host.setStatus(3, "");
                new ReadWorker(host, 0);
            }
            catch (Exception exception) {
                ServiceManager.log(exception.toString());
            }
        }
        try {
            this.mListeningSocket.close();
        }
        catch (IOException iOException) {
            ServiceManager.log(iOException.toString());
        }
        this.shutdownCompleted();
    }

    private String resolveSelfHostName() {
        InetAddress inetAddress = this.mListeningSocket.getInetAddress();
        String string = null;
        if (string == null) {
            string = inetAddress.getHostAddress();
        }
        if (string.equals("0.0.0.0")) {
            string = this.localAddress.getHostName();
        }
        return string;
    }

    private synchronized void shutdownCompleted() {
        this.mRunning = false;
        ServiceManager.log("Listener stops.");
        this.mShutdownCompleted = true;
        this.localAddress.updateAddress(HostAddress.LOCAL_HOST_NAME, 6346);
        if (this.mHostChangedListener != null) {
            this.mHostChangedListener.updateMyIP();
        }
        this.notifyAll();
    }
}

