/*
 * Decompiled with CFR 0.152.
 */
package phex;

import java.io.IOException;
import java.io.OutputStream;
import phex.FlexBuf;
import phex.SendManager;
import phex.ServiceManager;
import phex.host.Host;
import phex.host.HostManager;
import phex.host.HostMsg;
import phex.interfaces.IMsg;
import phex.utils.StatisticTracker;

public class SendWorker
implements Runnable {
    private SendManager mManager;
    private boolean mRequestToDie = false;

    private SendWorker() {
    }

    public SendWorker(SendManager sendManager) {
        this.mManager = sendManager;
    }

    public void startup() {
        this.mRequestToDie = false;
        new Thread((Runnable)this, "SendWorker-".concat(String.valueOf(String.valueOf(Integer.toHexString(this.hashCode()))))).start();
    }

    public void shutdown() {
        this.mRequestToDie = true;
    }

    public void run() {
        FlexBuf flexBuf = new FlexBuf();
        HostManager hostManager = ServiceManager.getHostManager();
        StatisticTracker statisticTracker = ServiceManager.getStatisticTracker();
        while (!this.mRequestToDie) {
            HostMsg hostMsg;
            block10: {
                Object var14_15;
                hostMsg = this.mManager.getNextHostMsg();
                if (this.mRequestToDie) {
                    this.mManager.queueMsgToSend(hostMsg);
                    break;
                }
                Host host = hostMsg.getHost();
                IMsg iMsg = hostMsg.getMsg();
                if (host == null || iMsg == null || !host.acquireSendLockOrQueueMsg(hostMsg)) continue;
                try {
                    block9: {
                        try {
                            OutputStream outputStream = host.getOs();
                            if (outputStream == null) break block9;
                            iMsg.computeHeaderLen();
                            int n = iMsg.getSize();
                            byte[] byArray = flexBuf.getBuf(n);
                            iMsg.serialize(byArray, 0);
                            boolean bl = false;
                            int n2 = 0;
                            for (int i = 0; i < n; i += n2) {
                                n2 = n - i;
                                if (n2 > 1024) {
                                    n2 = 1024;
                                }
                                outputStream.write(byArray, i, n2);
                                statisticTracker.incBytesCount(n2);
                                hostManager.throttleControl(n2);
                            }
                            host.incSentCount();
                        }
                        catch (IOException iOException) {
                            host.setStatus(1, iOException.getMessage());
                            var14_15 = null;
                            host.releaseSendLock();
                            break block10;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            var14_15 = null;
                            host.releaseSendLock();
                        }
                    }
                    var14_15 = null;
                    host.releaseSendLock();
                }
                catch (Throwable throwable) {
                    var14_15 = null;
                    host.releaseSendLock();
                    throw throwable;
                }
            }
            this.mManager.freeHostMsg(hostMsg);
        }
    }
}

