/*
 * Decompiled with CFR 0.152.
 */
package phex.config;

import java.awt.Font;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.UIManager;
import phex.GUID;
import phex.Res;
import phex.utils.IPUtils;

public class Cfg {
    public static final int DEFAULT_SOCKS5_PORT = 1080;
    public static final int UNLIMITED_BANDWIDTH = Integer.MAX_VALUE;
    public static int MIN_SEARCH_TERM_LENGTH = 2;
    public static final String sGeneralNetwork = "<General Gnutella Network>";
    public GUID mProgramClientID = new GUID();
    public String mMyIP = "";
    public int mListeningPort = -1;
    public int mMaxDownload = 4;
    public int mMaxDownloadPerIP = 1;
    public int mMaxUpload = 4;
    public int mMaxUploadPerIP = 1;
    public int mUploadMaxBandwidth = 102400;
    public int mNetTTL = 5;
    public int mNetMaxTTL = 7;
    public int mNetMaxHostToCatch = 5000;
    public int mNetMaxSendQueue = 500;
    public int mPingFrequency = 15000;
    public int mPingTimeout = 60000;
    public int mSearchMaxSearch = 500;
    public int mSearchMaxConcurrent = 10;
    public String mSearchFilter = "";
    public int mNetMaxConnection = 6;
    public int mNetMaxRate = 50000;
    public int mDownloadMaxBandwidth = 102400;
    public boolean mDownloadAutoRemoveCompleted = false;
    public String mDownloadDir = ".";
    public int mDownloadMaxRetry = 999;
    public int mDownloadRetryWait = 30000;
    public String mDownloadSaveFile = "";
    public String mXMLDownloadSaveFile = "";
    public String xmlResearchServiceFilename = "";
    public boolean mAutoConnect = true;
    public int mNetMinConn = 4;
    public boolean mAutoCleanup = true;
    public int mUploadMaxSearch = 100;
    public boolean mShareBrowseDir = true;
    public int mPushTransferTimeout = 60000;
    public Vector mNetIgnoredHosts = new Vector();
    public Vector mNetInvalidHosts = new Vector();
    public Vector mFilteredSearchHosts = new Vector();
    public boolean mApplyFilterdHosts = false;
    public String mCurrentNetwork = "<General Gnutella Network>";
    public Vector mNetNetworkHistory = new Vector();
    public boolean mAutoJoin = true;
    public Hashtable mNetworkPasswords = new Hashtable();
    public boolean mDisconnectApplyPolicy = true;
    public int mDisconnectDropRatio = 50;
    public int mDisconnectLatency = 60000;
    public boolean mIndexFiles = false;
    public boolean mProxyUse = false;
    public String mProxyHost = "";
    public int mProxyPort = 1080;
    public boolean useProxyAuthentication = false;
    public String mProxyUserName = "";
    public String mProxyPassword = "";
    public Font mFontMenu = new Font("Dialog", 0, 12);
    public Font mFontLabel = new Font("Dialog", 0, 12);
    public Font mFontTable = new Font("Dialog", 0, 12);
    public String mFindText = "";
    public boolean mFindMatchCase = false;
    public boolean mFindDown = true;
    public boolean mUIDisplayTooltip = true;
    public String mLFClassName = UIManager.getSystemLookAndFeelClassName();
    public String mUserName = "(noname)";
    public String mUploadDir = "";
    public String mUploadFileExclusions = "";
    public String mUploadFileInclusions = "*";
    public boolean mUploadScanRecursively = true;
    public boolean mUploadAutoRemoveCompleted = false;
    public String mHostFile = "";
    public String mLogFile = "";
    public String mDebugFile = "";
    public String mSearchLastSearch = "";
    public int mSearchMinSpeed = 0;
    public boolean mPhexPingResponse = true;
    public boolean monitorSearchHistory = true;
    public int searchHistoryLength = 10;
    public long mMinimumFileSize = 0L;
    public long mMaximumFileSize = Long.MAX_VALUE;
    public int networkSpeedKbps = 256;
    public int maxTotalBandwidth = 16384;
    public String runningPhexVersion = "";
    public boolean isBehindFirewall = false;
    public String lastUpdateCheckVersion = "0";
    public long lastUpdateCheckTime = 0L;
    public boolean showUpdateNotification = true;
    public int mSocketTimeout = 120000;
    public int privateSocketTimeout = 2000;
    public int mNetConnectionTimeout = 30000;
    public int searchRetryTimeout = 30000;
    public Vector mSearchFilterTokens = new Vector();
    private String mCfgFilename;
    private Properties mSetting = new Properties();
    private Hashtable mOldNames = new Hashtable();

    private Cfg() {
    }

    public Cfg(String string) {
        this.setupOldNames();
        this.mCfgFilename = string;
    }

    public String getConfigFilename() {
        return this.mCfgFilename;
    }

    public void load() {
        Object object;
        try {
            object = new FileInputStream(this.mCfgFilename);
            this.mSetting.load((InputStream)object);
            ((FileInputStream)object).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(exception);
        }
        this.deserializeSimpleFields();
        this.deserializeComplexFields();
        this.breakSearchFilter();
        this.handlePhexVersionAdjustments();
        if (this.mListeningPort == -1) {
            object = new Random(System.currentTimeMillis());
            this.mListeningPort = ((Random)object).nextInt();
            this.mListeningPort = this.mListeningPort < 0 ? -this.mListeningPort : this.mListeningPort;
            this.mListeningPort %= 8000;
            this.mListeningPort += 2000;
        }
        this.mOldNames.clear();
        this.mOldNames = null;
    }

    public void save() {
        ((Hashtable)this.mSetting).clear();
        this.serializeSimpleFields();
        this.serializeComplexField();
        this.breakSearchFilter();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.mCfgFilename);
            this.mSetting.save(fileOutputStream, "PHEX Config Values");
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.out.println(iOException);
        }
    }

    private String get(String string) {
        String string2;
        String string3 = (String)((Hashtable)this.mSetting).get(string);
        if (string3 == null && (string2 = (String)this.mOldNames.get(string)) != null) {
            string3 = (String)((Hashtable)this.mSetting).get(string2);
        }
        if (string3 != null) {
            string3 = string3.trim();
        }
        return string3;
    }

    private String get(String string, String string2) {
        String string3 = this.get(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    private boolean getBool(String string, boolean bl) {
        return this.get(string, bl ? "true" : "false").equals("true");
    }

    private void set(String string, String string2) {
        ((Hashtable)this.mSetting).put(string, string2);
    }

    private void set(String string, long l) {
        ((Hashtable)this.mSetting).put(string, String.valueOf(l));
    }

    private void set(String string, boolean bl) {
        ((Hashtable)this.mSetting).put(string, bl ? "true" : "false");
    }

    private void breakSearchFilter() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.mSearchFilter);
        this.mSearchFilterTokens.removeAllElements();
        while (stringTokenizer.hasMoreTokens()) {
            this.mSearchFilterTokens.addElement(stringTokenizer.nextToken());
        }
    }

    private void serializeSimpleFields() {
        Field[] fieldArray = this.getClass().getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            String string = fieldArray[i].getName();
            int n = fieldArray[i].getModifiers();
            Class<?> clazz = fieldArray[i].getType();
            if (!Modifier.isPublic(n) || Modifier.isTransient(n) || Modifier.isStatic(n)) continue;
            try {
                if (clazz.getName().equals("int")) {
                    this.set(string, fieldArray[i].getInt(this));
                    continue;
                }
                if (clazz.getName().equals("long")) {
                    this.set(string, fieldArray[i].getLong(this));
                    continue;
                }
                if (clazz.getName().equals("boolean")) {
                    this.set(string, fieldArray[i].getBoolean(this));
                    continue;
                }
                if (!clazz.getName().equals("java.lang.String")) continue;
                this.set(string, (String)fieldArray[i].get(this));
                continue;
            }
            catch (Exception exception) {
                System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" ").append(exception))));
            }
        }
    }

    private void serializeComplexField() {
        try {
            this.set("mProgramClientID", this.mProgramClientID.toHexString());
            String string = "";
            for (int i = 0; i < this.mNetIgnoredHosts.size(); ++i) {
                String[] stringArray = (String[])this.mNetIgnoredHosts.elementAt(i);
                string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(stringArray[0]))).append(".").append(stringArray[1]).append(".").append(stringArray[2]).append(".").append(stringArray[3]).append(" "))))));
            }
            this.set("mNetIgnoredHosts", string);
            String string2 = "";
            for (int i = 0; i < this.mFilteredSearchHosts.size(); ++i) {
                String[] stringArray = (String[])this.mFilteredSearchHosts.elementAt(i);
                string2 = String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(stringArray[0]))).append(".").append(stringArray[1]).append(".").append(stringArray[2]).append(".").append(stringArray[3]).append(" "))))));
            }
            this.set("mFilteredSearchHosts", string2);
            String string3 = "";
            for (int i = 0; i < this.mNetInvalidHosts.size(); ++i) {
                String[] stringArray = (String[])this.mNetInvalidHosts.elementAt(i);
                string3 = String.valueOf(String.valueOf(string3)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(stringArray[0]))).append(".").append(stringArray[1]).append(".").append(stringArray[2]).append(".").append(stringArray[3]).append(" "))))));
            }
            this.set("mNetInvalidHosts", string3);
            String string4 = "";
            for (int i = 0; i < this.mNetNetworkHistory.size(); ++i) {
                string4 = String.valueOf(String.valueOf(string4)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(this.mNetNetworkHistory.elementAt(i))).concat(" "))));
            }
            this.set("mNetNetworkHistory", string4);
            String string5 = "";
            Enumeration enumeration = this.mNetworkPasswords.keys();
            while (enumeration.hasMoreElements()) {
                String string6 = (String)enumeration.nextElement();
                String string7 = (String)this.mNetworkPasswords.get(string6);
                string5 = String.valueOf(String.valueOf(string5)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string6))).append(", ").append(string7).append(", "))))));
            }
            this.set("mNetworkPasswords", string5);
            this.set("mFontMenu", String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.mFontMenu.getName()))).append(";").append(this.mFontMenu.getStyle()).append(";").append(this.mFontMenu.getSize()))));
            this.set("mFontLabel", String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.mFontLabel.getName()))).append(";").append(this.mFontLabel.getStyle()).append(";").append(this.mFontLabel.getSize()))));
            this.set("mFontTable", String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.mFontTable.getName()))).append(";").append(this.mFontTable.getStyle()).append(";").append(this.mFontTable.getSize()))));
            this.breakSearchFilter();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    private void deserializeSimpleFields() {
        Field[] fieldArray = this.getClass().getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            String string = fieldArray[i].getName();
            int n = fieldArray[i].getModifiers();
            Class<?> clazz = fieldArray[i].getType();
            if (!Modifier.isPublic(n) || Modifier.isTransient(n) || Modifier.isStatic(n)) continue;
            try {
                String string2 = this.get(string);
                if (string2 == null) continue;
                if (clazz.getName().equals("int")) {
                    fieldArray[i].setInt(this, Integer.parseInt(string2));
                    continue;
                }
                if (clazz.getName().equals("long")) {
                    fieldArray[i].setLong(this, Long.parseLong(string2));
                    continue;
                }
                if (clazz.getName().equals("boolean")) {
                    fieldArray[i].setBoolean(this, string2.equals("true"));
                    continue;
                }
                if (!clazz.getName().equals("java.lang.String")) continue;
                fieldArray[i].set(this, string2);
                continue;
            }
            catch (Exception exception) {
                System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" ").append(exception))));
            }
        }
    }

    private void deserializeComplexFields() {
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            try {
                this.mProgramClientID.fromHexString(this.get("mProgramClientID"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            String string = this.get("mNetIgnoredHosts", "");
            Object object5 = new StringTokenizer(string);
            while (((StringTokenizer)object5).hasMoreTokens()) {
                this.mNetIgnoredHosts.addElement(IPUtils.splitIP2Parts(((StringTokenizer)object5).nextToken()));
            }
            object5 = this.get("mFilteredSearchHosts", "");
            if (object5 == null) {
                this.mFilteredSearchHosts = Cfg.getDefaultFilteredHosts();
            } else {
                object4 = new StringTokenizer((String)object5);
                while (((StringTokenizer)object4).hasMoreTokens()) {
                    this.mFilteredSearchHosts.addElement(IPUtils.splitIP2Parts(((StringTokenizer)object4).nextToken()));
                }
            }
            object4 = this.get("mNetInvalidHosts");
            if (object4 == null) {
                this.mNetInvalidHosts = Cfg.getDefaultInvalidHosts();
            } else {
                object3 = new StringTokenizer((String)object4);
                while (((StringTokenizer)object3).hasMoreTokens()) {
                    this.mNetInvalidHosts.addElement(IPUtils.splitIP2Parts(((StringTokenizer)object3).nextToken()));
                }
            }
            object3 = this.get("mNetNetworkHistory", "");
            Object object6 = new StringTokenizer((String)object3);
            while (((StringTokenizer)object6).hasMoreTokens()) {
                this.mNetNetworkHistory.addElement(((StringTokenizer)object6).nextToken());
            }
            this.mNetworkPasswords.clear();
            object6 = this.get("mNetworkPasswords", "");
            try {
                object2 = new StringTokenizer((String)object6, ",");
                while (((StringTokenizer)object2).hasMoreTokens()) {
                    object = ((StringTokenizer)object2).nextToken().trim();
                    String string2 = ((StringTokenizer)object2).nextToken().trim();
                    this.mNetworkPasswords.put(object, string2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if ((object2 = this.get("mFontMenu")) != null) {
                try {
                    object = new StringTokenizer((String)object2, ";");
                    this.mFontMenu = new Font(((StringTokenizer)object).nextToken(), Integer.parseInt(((StringTokenizer)object).nextToken()), Integer.parseInt(((StringTokenizer)object).nextToken()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((object2 = this.get("mFontLabel")) != null) {
                try {
                    object = new StringTokenizer((String)object2, ";");
                    this.mFontLabel = new Font(((StringTokenizer)object).nextToken(), Integer.parseInt(((StringTokenizer)object).nextToken()), Integer.parseInt(((StringTokenizer)object).nextToken()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((object2 = this.get("mFontTable")) != null) {
                try {
                    object = new StringTokenizer((String)object2, ";");
                    this.mFontTable = new Font(((StringTokenizer)object).nextToken(), Integer.parseInt(((StringTokenizer)object).nextToken()), Integer.parseInt(((StringTokenizer)object).nextToken()));
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setupOldNames() {
        this.mOldNames.put("mProgramClientID", "Program.CientID");
        this.mOldNames.put("mNetIgnoredHosts", "Net.IgnoredHosts");
        this.mOldNames.put("mNetFilteredSearchHosts", "Net.FilteredSearchHosts");
        this.mOldNames.put("mNetInvalidHosts", "Net.InvalidHosts");
        this.mOldNames.put("mNetNetworkHistory", "Net.NetworkHistory");
        this.mOldNames.put("mMyIP", "Net.MyIP");
        this.mOldNames.put("mListeningPort", "Net.ListeningPort");
        this.mOldNames.put("mMaxDownload", "Download.MaxDownload");
        this.mOldNames.put("mMaxDownloadPerIP", "Download.MaxDownloadPerIP");
        this.mOldNames.put("mDownloadMaxBandwidth", "Download.MaxBandwidth");
        this.mOldNames.put("mMaxUpload", "Upload.MaxUpload");
        this.mOldNames.put("mMaxUploadPerIP", "Upload.MaxUploadPerIP");
        this.mOldNames.put("mUploadMaxBandwidth", "Upload.MaxBandwidth");
        this.mOldNames.put("mNetTTL", "Net.TTL");
        this.mOldNames.put("mNetMaxTTL", "Net.MaxTTL");
        this.mOldNames.put("mNetMaxSendQueue", "Net.MaxSendQueue");
        this.mOldNames.put("mDisconnectDropRatio", "Disconnect.DropRatio");
        this.mOldNames.put("mDisconnectLatency", "Disconnect.Latency");
        this.mOldNames.put("mPingFrequency", "Net.PingFrequency");
        this.mOldNames.put("mPingTimeout", "Net.PingTimeout");
        this.mOldNames.put("mBehindFirewall", "Net.BehindFirewall");
        this.mOldNames.put("isBehindFirewall", "mBehindFirewall");
        this.mOldNames.put("mSearchMaxSearch", "Search.MaxSearch");
        this.mOldNames.put("mSearchFilter", "Search.Filter");
        this.mOldNames.put("mSearchEnableMonitor", "Search.EnableMonitor");
        this.mOldNames.put("mNetMaxConnection", "Net.MaxConnection");
        this.mOldNames.put("mNetMaxRate", "Net.MaxRate");
        this.mOldNames.put("mNetConnectionTimeout", "Net.ConnectionTimeout");
        this.mOldNames.put("mDownloadAutoRemoveCompleted", "Download.AutoRemoveCompleted");
        this.mOldNames.put("mUploadAutoRemoveCompleted", "Upload.AutoRemoveCompleted");
        this.mOldNames.put("mDownloadDir", "Download.Dir");
        this.mOldNames.put("mAutoSearchCandidate", "Download.AutoSearchCandidate");
        this.mOldNames.put("mAutoConnect", "Net.AutoConnect");
        this.mOldNames.put("mNetMinConn", "Net.MinConn");
        this.mOldNames.put("mAutoCleanup", "Net.AutoCleanup");
        this.mOldNames.put("mUploadMaxSearch", "Upload.MaxSearch");
        this.mOldNames.put("mShareEnabled", "Share.Enabled");
        this.mOldNames.put("mShareBrowseDir", "Share.BrowseDir");
        this.mOldNames.put("mPushTransferTimeout", "Download.PushTransferTimeout");
        this.mOldNames.put("mApplyFilterdHosts", "Net.ApplyFilterdHosts");
        this.mOldNames.put("mCurrentNetwork", "Net.CurrentNetwork");
        this.mOldNames.put("mAutoJoin", "Net.AutoJoin");
        this.mOldNames.put("mSaveMyPassword", "Host.SaveMyPassword");
        this.mOldNames.put("mIndexFiles", "Upload.IndexFiles");
        this.mOldNames.put("mProxyUse", "Proxy.Use");
        this.mOldNames.put("mProxyHost", "Proxy.Host");
        this.mOldNames.put("mProxyPort", "Proxy.Port");
        this.mOldNames.put("mProxyUserName", "Proxy.UserName");
        this.mOldNames.put("mProxyPassword", "Proxy.Password");
        this.mOldNames.put("mLFClassName", "LF.ClassName");
        this.mOldNames.put("mUserName", "User.Name");
        this.mOldNames.put("mUploadDir", "Upload.Dir");
        this.mOldNames.put("mUploadFileExclusions", "Upload.FileExclusions");
        this.mOldNames.put("mUploadFileInclusions", "Upload.FileInclusions");
        this.mOldNames.put("mUploadScanRecursively", "Upload.ScanRecursively");
        this.mOldNames.put("mUploadAutoRemoveCompleted", "Upload.AutoRemoveCompleted");
        this.mOldNames.put("mHostFile", "HostFile");
        this.mOldNames.put("mLogFile", "LogFile");
        this.mOldNames.put("mDebugFile", "DebugFile");
        this.mOldNames.put("mDownloadSaveFile", "DownloadSaveFile");
        this.mOldNames.put("mSearchLastSearch", "Search.LastSearch");
        this.mOldNames.put("mSearchMinSpeed", "Search.MinSpeed");
        this.mOldNames.put("mFontMenu", "Font.Menu");
        this.mOldNames.put("mFontLabel", "Font.Label");
        this.mOldNames.put("mFontTable", "Font.Table");
    }

    public static Vector getDefaultInvalidHosts() {
        Vector<String[]> vector = new Vector<String[]>();
        vector.addElement(IPUtils.splitIP2Parts("0.0.0.0"));
        vector.addElement(IPUtils.splitIP2Parts("255.*.*.*"));
        vector.addElement(IPUtils.splitIP2Parts("10.0.0.*"));
        vector.addElement(IPUtils.splitIP2Parts("172.16.*.*"));
        vector.addElement(IPUtils.splitIP2Parts("192.168.*.*"));
        return vector;
    }

    public static Vector getDefaultFilteredHosts() {
        Vector<String[]> vector = new Vector<String[]>();
        vector.addElement(IPUtils.splitIP2Parts("0.0.0.0"));
        vector.addElement(IPUtils.splitIP2Parts("255.*.*.*"));
        vector.addElement(IPUtils.splitIP2Parts("10.0.0.*"));
        vector.addElement(IPUtils.splitIP2Parts("172.16.*.*"));
        vector.addElement(IPUtils.splitIP2Parts("192.168.*.*"));
        return vector;
    }

    public void handlePhexVersionAdjustments() {
        if (this.runningPhexVersion == null || this.runningPhexVersion.length() == 0) {
            if (this.mNetMaxHostToCatch < 5000) {
                this.mNetMaxHostToCatch = 5000;
            }
            this.runningPhexVersion = "0.6";
        }
        if (this.runningPhexVersion.equals("0.6") || this.runningPhexVersion.equals("0.6.1")) {
            this.updatesFor0_6_2();
        }
        this.runningPhexVersion = Res.getStr("Program.Version");
        this.save();
    }

    private void updatesFor0_6_2() {
        int n;
        this.useProxyAuthentication = this.mProxyUserName.length() > 0;
        int n2 = Math.max(this.mNetMaxRate, Math.max(this.mUploadMaxBandwidth, this.mDownloadMaxBandwidth));
        this.networkSpeedKbps = n = n2 / 1024 * 8;
        this.maxTotalBandwidth = n2;
    }
}

