/*
 * Decompiled with CFR 0.152.
 */
package phex.dialogues;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import phex.BaseFrame;
import phex.ServiceManager;
import phex.download.DownloadFile;
import phex.download.DownloadManager;
import phex.download.RemoteFile;

public class DlgAddAsCandidate
extends JDialog
implements KeyListener {
    private BaseFrame mFrame;
    private JList mList;
    private boolean mCancel;
    private Vector mDownloads = new Vector();
    private DownloadFile mDownloadFile = null;

    public DlgAddAsCandidate(BaseFrame baseFrame, RemoteFile remoteFile) {
        super((Frame)baseFrame, true);
        Serializable serializable;
        this.mFrame = baseFrame;
        DownloadManager downloadManager = ServiceManager.getDownloadManager();
        for (int i = 0; i < downloadManager.getDownloadCount(); ++i) {
            serializable = downloadManager.getDownloadFileAt(i);
            if (serializable == null || remoteFile.getFileSize() != ((DownloadFile)serializable).getTotalFileSize()) continue;
            this.mDownloads.addElement(serializable);
        }
        this.setTitle("Add as Download Candidate");
        this.setDefaultCloseOperation(1);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 20, 0, 0));
        jPanel.add("Center", new JLabel("Select a download file to add the remote file as its download candidate"));
        serializable = new JPanel(new BorderLayout());
        ((JComponent)serializable).setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20), BorderFactory.createEtchedBorder()), BorderFactory.createEmptyBorder(16, 20, 20, 20)));
        this.mList = new JList(this.mDownloads);
        ((Container)serializable).add("North", new JLabel("Current Matching Download:"));
        ((Container)serializable).add("Center", new JScrollPane(this.mList));
        this.mList.setPreferredSize(new Dimension(320, 200));
        if (this.mDownloads.size() > 0) {
            this.mList.setSelectedIndex(0);
        }
        this.getContentPane().add("North", jPanel);
        this.getContentPane().add("Center", (Component)serializable);
        JPanel jPanel2 = new JPanel(new FlowLayout());
        JButton jButton = new JButton("OK");
        JButton jButton2 = new JButton("Cancel");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!actionEvent.getActionCommand().equals("Cancel")) {
                    if (!DlgAddAsCandidate.this.doOk()) {
                        return;
                    }
                } else {
                    DlgAddAsCandidate.this.mCancel = true;
                }
                ((Component)DlgAddAsCandidate.this).setVisible(false);
            }
        };
        jButton.addActionListener(actionListener);
        jButton.setMnemonic('O');
        jButton2.addActionListener(actionListener);
        jButton2.setMnemonic('C');
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        this.getContentPane().add("South", jPanel2);
        this.addKeyListener(this);
        this.pack();
        BaseFrame.centerWindow(this, new Point(0, 0));
    }

    public DownloadFile getDownloadFile() {
        return this.mDownloadFile;
    }

    public boolean getCancel() {
        return this.mCancel;
    }

    private boolean doOk() {
        DownloadFile downloadFile = (DownloadFile)this.mList.getSelectedValue();
        if (downloadFile == null) {
            return false;
        }
        this.mDownloadFile = downloadFile;
        this.mCancel = false;
        return true;
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            this.mCancel = true;
            ((Component)this).setVisible(false);
        } else if (keyEvent.getKeyCode() == 10) {
            if (!this.doOk()) {
                return;
            }
            this.mCancel = false;
            ((Component)this).setVisible(false);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }
}

