/*
 * Decompiled with CFR 0.152.
 */
package phex.dialogues;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import phex.BaseFrame;
import phex.ServiceManager;

public class DlgConfigDisconnect
extends JDialog
implements KeyListener {
    private BaseFrame mFrame;
    private boolean mCancel;
    private JCheckBox mApplyPolicy;
    private JTextField mSendQueueText;
    private JTextField mDropPacketText;
    private JTextField mLatencyText;

    public DlgConfigDisconnect(BaseFrame baseFrame) {
        super((Frame)baseFrame, true);
        this.setTitle("Configure Disconnect Policy");
        this.setDefaultCloseOperation(1);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(20, 20, 6, 20), BorderFactory.createEtchedBorder()), BorderFactory.createEmptyBorder(16, 20, 20, 20)));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.mApplyPolicy = new JCheckBox("Apply disconnect policies.", ServiceManager.sCfg.mDisconnectApplyPolicy);
        jPanel2.add("Center", this.mApplyPolicy);
        jPanel2.add("South", new JLabel(" "));
        JPanel jPanel3 = new JPanel(new GridLayout(3, 1, 10, 0));
        jPanel3.add(new JLabel("Send Queue Exceeds: "));
        jPanel3.add(new JLabel("Drop Packet Exceeds (%): "));
        jPanel3.add(new JLabel("Latency Timeout Exceeds (sec):"));
        JPanel jPanel4 = new JPanel(new GridLayout(3, 1, 10, 6));
        this.mSendQueueText = new JTextField(Integer.toString(ServiceManager.sCfg.mNetMaxSendQueue), 10);
        this.mDropPacketText = new JTextField(Integer.toString(ServiceManager.sCfg.mDisconnectDropRatio), 10);
        this.mLatencyText = new JTextField(Integer.toString(ServiceManager.sCfg.mDisconnectLatency / 1000), 10);
        jPanel4.add(this.mSendQueueText);
        jPanel4.add(this.mDropPacketText);
        jPanel4.add(this.mLatencyText);
        jPanel.add("North", jPanel2);
        jPanel.add("West", jPanel3);
        jPanel.add("Center", jPanel4);
        this.getContentPane().add("Center", jPanel);
        JPanel jPanel5 = new JPanel(new FlowLayout());
        JButton jButton = new JButton("OK");
        JButton jButton2 = new JButton("Cancel");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!actionEvent.getActionCommand().equals("Cancel")) {
                    if (!DlgConfigDisconnect.this.doOk()) {
                        return;
                    }
                } else {
                    DlgConfigDisconnect.this.mCancel = true;
                }
                ((Component)DlgConfigDisconnect.this).setVisible(false);
            }
        };
        jButton.addActionListener(actionListener);
        jButton.setMnemonic('O');
        jButton2.addActionListener(actionListener);
        jButton2.setMnemonic('C');
        jPanel5.add(jButton);
        jPanel5.add(jButton2);
        this.getContentPane().add("South", jPanel5);
        this.addKeyListener(this);
        this.pack();
        BaseFrame.centerWindow(this, new Point(0, 0));
    }

    public boolean getCancel() {
        return this.mCancel;
    }

    private boolean doOk() {
        int n;
        int n2;
        int n3;
        try {
            n3 = Integer.parseInt(this.mSendQueueText.getText().trim());
            if (n3 < 0) {
                throw new Exception();
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.mFrame, "Please enter a non-negative integer.", "Please Enter Again", 0);
            this.mSendQueueText.requestFocus();
            boolean bl = false;
            return bl;
        }
        if (n3 > 1000) {
            n3 = 1000;
        }
        try {
            n2 = Integer.parseInt(this.mDropPacketText.getText().trim());
            if (n2 < 1 || n2 > 100) {
                throw new Exception();
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.mFrame, "Please enter a number between 1 and 100.", "Please Enter Again", 0);
            this.mDropPacketText.requestFocus();
            boolean bl = false;
            return bl;
        }
        try {
            n = Integer.parseInt(this.mLatencyText.getText().trim());
            if (n < 0) {
                throw new Exception();
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.mFrame, "Please enter a non-negative integer.", "Please Enter Again", 0);
            this.mLatencyText.requestFocus();
            boolean bl = false;
            return bl;
        }
        ServiceManager.sCfg.mDisconnectApplyPolicy = this.mApplyPolicy.isSelected();
        ServiceManager.sCfg.mNetMaxSendQueue = n3;
        ServiceManager.sCfg.mDisconnectDropRatio = n2;
        ServiceManager.sCfg.mDisconnectLatency = n * 1000;
        ServiceManager.sCfg.save();
        this.mCancel = false;
        return true;
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            this.mCancel = true;
            ((Component)this).setVisible(false);
        } else if (keyEvent.getKeyCode() == 10 && this.doOk()) {
            this.mCancel = false;
            ((Component)this).setVisible(false);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }
}

