/*
 * Decompiled with CFR 0.152.
 */
package phex.download;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.Socket;
import java.net.URL;
import javax.swing.JOptionPane;
import phex.ServiceManager;
import phex.download.DownloadFile;
import phex.download.DownloadManager;
import phex.host.Host;
import phex.host.HostAddress;
import phex.utils.IOUtil;
import phex.utils.StrUtil;
import phex.utils.ThrottleController;

public class DownloadWorker
implements Runnable {
    private DownloadManager mManager;
    private DownloadFile mDownload = null;
    private Host mHost = null;

    private DownloadWorker() {
    }

    public DownloadWorker(DownloadManager downloadManager) {
        this.mManager = downloadManager;
        new Thread((Runnable)this, "DownloadWorker-".concat(String.valueOf(String.valueOf(Integer.toHexString(this.hashCode()))))).start();
    }

    public void stopDownload() {
        if (this.mHost != null) {
            this.mHost.disconnect();
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        var1_1 = new byte[1024];
        var2_2 = var1_1.length;
        var3_3 = null;
        while (true) {
            block80: {
                block81: {
                    block71: {
                        block78: {
                            block79: {
                                block67: {
                                    block76: {
                                        block77: {
                                            block66: {
                                                block63: {
                                                    block75: {
                                                        block64: {
                                                            this.mDownload = this.mManager.getNextFileToDownload(this);
                                                            if (this.mDownload == null) {
                                                                ServiceManager.log("DownloadWorker terminated.");
                                                                return;
                                                            }
                                                            var5_5 = this.mDownload.getFullLocalFilename();
                                                            var6_6 = this.mDownload.getDownloadName();
                                                            try {
                                                                try {
                                                                    block70: {
                                                                        block68: {
                                                                            block65: {
                                                                                this.mManager.incDownloadingCount();
                                                                                this.mDownload.appendLog("Start download.");
                                                                                if (!this.deleteExistingFile(var5_5)) {
                                                                                    this.mDownload.setStatus(8);
                                                                                    var27_27 = null;
                                                                                    this.mManager.decDownloadingCount();
                                                                                    if (this.mHost != null) {
                                                                                        this.mHost.disconnect();
                                                                                        this.mHost = null;
                                                                                    }
                                                                                    if (var3_3 == null) break block63;
                                                                                    break block64;
                                                                                }
                                                                                var7_7 = new File(var6_6);
                                                                                var8_9 = false;
                                                                                var9_10 = 0;
                                                                                var10_11 = 0L;
                                                                                if (var7_7.exists()) {
                                                                                    var8_9 = true;
                                                                                    var10_11 = var7_7.length() - (long)1024;
                                                                                    if (var10_11 < (long)0) {
                                                                                        var10_11 = 0L;
                                                                                    }
                                                                                    var12_12 = new Long(var10_11);
                                                                                    var9_10 = var12_12.intValue();
                                                                                }
                                                                                this.mDownload.appendLog("position to read=".concat(String.valueOf(String.valueOf(var9_10))));
                                                                                try {
                                                                                    this.mDownload.appendLog("Download name=".concat(String.valueOf(String.valueOf(var6_6))));
                                                                                    var3_3 = new RandomAccessFile(var6_6, "rw");
                                                                                }
                                                                                catch (Exception var12_13) {
                                                                                    var13_14 = "Failed to create the file '";
                                                                                    var13_14 = String.valueOf(String.valueOf(var13_14)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(var5_5)).concat("' to save the download content.  "))));
                                                                                    var13_14 = String.valueOf(String.valueOf(var13_14)).concat(String.valueOf(String.valueOf(var12_13.getMessage())));
                                                                                    JOptionPane.showMessageDialog(ServiceManager.getManager().getMainFrame(), var13_14, "Failed To Create File", 0);
                                                                                    throw var12_13;
                                                                                }
                                                                                this.mDownload.appendLog("Connect ".concat(String.valueOf(String.valueOf(this.mDownload.getCurrentRemoteFile().getURL()))));
                                                                                var12_12 = new URL(this.mDownload.getCurrentRemoteFile().getURL());
                                                                                var13_14 = new HostAddress(var12_12.getHost(), var12_12.getPort());
                                                                                this.mHost = new Host();
                                                                                this.mHost.setType(3);
                                                                                try {
                                                                                    var14_15 = ServiceManager.getConnectionManager().connect(var12_12.getHost(), var12_12.getPort());
                                                                                    this.mDownload.appendLog("Normal connection ok");
                                                                                    this.mHost.setSock((Socket)var14_15);
                                                                                    this.mHost.setOs(var14_15.getOutputStream());
                                                                                    this.mHost.setIs(var14_15.getInputStream());
                                                                                }
                                                                                catch (Exception var14_16) {
                                                                                    this.mDownload.appendLog("Normal connection failed.  ".concat(String.valueOf(String.valueOf(var14_16.getMessage()))));
                                                                                    if (ServiceManager.sCfg.isBehindFirewall) {
                                                                                        this.mDownload.removeCurrentCandidate();
                                                                                        this.mDownload.appendLog("Download failed.  ".concat(String.valueOf(String.valueOf(var14_16.toString()))));
                                                                                        throw new IOException("Download failed.  ".concat(String.valueOf(String.valueOf(var14_16.toString()))));
                                                                                    }
                                                                                    this.mDownload.setStatus(5, var14_16.getMessage());
                                                                                    Thread.sleep(5000L);
                                                                                    this.mDownload.appendLog("Try push request.");
                                                                                    this.mHost = this.mManager.pushRequestTransfer(this.mHost, this.mDownload);
                                                                                    if (this.mHost != null) break block65;
                                                                                    throw new IOException("Time out on requesting push transfer.");
                                                                                }
                                                                            }
                                                                            if (this.mDownload.getStatus() == 7) throw new IOException("Download stopped.");
                                                                            if (this.mDownload.getStatus() == 9) {
                                                                                throw new IOException("Download stopped.");
                                                                            }
                                                                            var14_15 = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.mDownload.getCurrentRemoteFile().getGetRequest()))).append("User-Agent: ").append(StrUtil.getAppNameVersion()).append("\r\n").append(this.mDownload.getRangeHeader(var9_10)).append("\r\n")));
                                                                            this.mDownload.appendLog("Send download handshake: ".concat(String.valueOf(String.valueOf(var14_15))));
                                                                            var4_4 = IOUtil.serializeString((String)var14_15, var1_1, 0);
                                                                            this.mHost.getOs().write(var1_1, 0, var4_4);
                                                                            var15_17 = this.mHost.getIs();
                                                                            var4_4 = IOUtil.readToCRLF(var15_17, var1_1, var2_2, 0);
                                                                            var16_18 = new StringBuffer();
                                                                            IOUtil.deserializeString(var1_1, 0, var4_4, var16_18);
                                                                            var17_19 = var16_18.toString().toUpperCase();
                                                                            this.mDownload.appendLog("Remote host replies: ".concat(String.valueOf(String.valueOf(var17_19))));
                                                                            if (!var17_19.startsWith("HTTP")) {
                                                                                this.mDownload.removeCurrentCandidate();
                                                                                throw new Exception("Invalid response from remote host.");
                                                                            }
                                                                            if (var17_19.indexOf("503") != -1) {
                                                                                this.mDownload.setStatus(6);
                                                                                this.mDownload.appendLog("Remote host is busy.");
                                                                                break block66;
                                                                            }
                                                                            if (var17_19.indexOf("404") != -1 || var17_19.indexOf("410") != -1) {
                                                                                this.mDownload.appendLog("File not available. Host removed.");
                                                                                this.mDownload.removeCurrentCandidate();
                                                                                break block67;
                                                                            }
                                                                            if (var17_19.indexOf("200 OK") == -1 && var17_19.indexOf("206 OK") == -1) {
                                                                                this.mDownload.removeCurrentCandidate();
                                                                                throw new Exception("Negative response to download request.");
                                                                            }
                                                                            var18_20 = null;
                                                                            var19_21 = false;
                                                                            while (true) {
                                                                                if ((var4_4 = IOUtil.readToCRLF(var15_17, var1_1, var2_2, 0)) == 0) {
                                                                                    this.mDownload.setRemoteAppName(var18_20);
                                                                                    if (!var19_21) {
                                                                                        break;
                                                                                    }
                                                                                    break block68;
                                                                                }
                                                                                var16_18 = new StringBuffer();
                                                                                IOUtil.deserializeString(var1_1, 0, var4_4, var16_18);
                                                                                var17_19 = var16_18.toString().toUpperCase();
                                                                                this.mDownload.appendLog(var17_19);
                                                                                if (var17_19.startsWith("CONTENT-LENGTH:")) {
                                                                                    var19_21 = true;
                                                                                }
                                                                                if (var17_19.startsWith("CONTENT-RANGE:")) {
                                                                                    var19_21 = true;
                                                                                }
                                                                                if (!var17_19.startsWith("SERVER:")) continue;
                                                                                var18_20 = var17_19.substring(7).trim();
                                                                            }
                                                                            this.mDownload.removeCurrentCandidate();
                                                                            throw new Exception("Invalid header from remote host.");
                                                                        }
                                                                        if (var9_10 > 0 && !this.hasServerResumeSupport(var18_20)) {
                                                                            this.mDownload.removeCurrentCandidate();
                                                                            throw new IOException("Candidate doesn't support resuming.");
                                                                        }
                                                                        var20_22 = 0;
                                                                        this.mDownload.appendLog("Downloading...");
                                                                        this.mDownload.setStartSize(var9_10);
                                                                        this.mDownload.setStartingTime(System.currentTimeMillis());
                                                                        this.mDownload.setStatus(2);
                                                                        var21_23 = ThrottleController.acquireThrottle();
                                                                        try {
                                                                            try {
                                                                                var3_3.seek(var10_11);
                                                                                while ((long)var20_22 < this.mDownload.getTransferDataSize() && (var4_4 = var15_17.read(var1_1)) != -1) {
                                                                                    var3_3.write(var1_1, 0, var4_4);
                                                                                    this.mDownload.setTransferredDataSize(var20_22 += var4_4);
                                                                                    var21_23.setRate(ServiceManager.sCfg.mDownloadMaxBandwidth / this.mManager.getDownloadingCount());
                                                                                    var21_23.controlThrottle(var4_4);
                                                                                }
                                                                                var24_25 = null;
                                                                            }
                                                                            catch (Exception var22_24) {
                                                                                if ((long)var20_22 < this.mDownload.getTransferDataSize()) {
                                                                                    this.mDownload.appendLog(String.valueOf(String.valueOf(new StringBuffer("Transfered ended on exception with only ").append(var20_22).append(" of ").append(this.mDownload.getTransferDataSize()).append(" bytes transfered!"))));
                                                                                    throw var22_24;
                                                                                }
                                                                                var24_25 = null;
                                                                                ThrottleController.releaseThrottle(var21_23);
                                                                                var21_23 = null;
                                                                                break block70;
                                                                            }
                                                                        }
                                                                        catch (Throwable var23_29) {
                                                                            var24_25 = null;
                                                                            ThrottleController.releaseThrottle(var21_23);
                                                                            var21_23 = null;
                                                                            throw var23_29;
                                                                        }
                                                                        ThrottleController.releaseThrottle(var21_23);
                                                                        var21_23 = null;
                                                                    }
                                                                    if ((long)var20_22 < this.mDownload.getTransferDataSize()) {
                                                                        this.mDownload.appendLog(String.valueOf(String.valueOf(new StringBuffer("Transfered ended with only ").append(var20_22).append("/").append(this.mDownload.getTransferDataSize()).append(" transfered!"))));
                                                                        throw new IOException("Disconnected from remote host");
                                                                    }
                                                                    this.mDownload.setTransferredDataSize(var20_22);
                                                                    this.mDownload.setStatus(4);
                                                                    this.mDownload.setStoppingTime(System.currentTimeMillis());
                                                                    this.mDownload.appendLog("Download completed");
                                                                    var25_26 = ServiceManager.getStatisticTracker();
                                                                    var25_26.incStatDownloadCount(1);
                                                                    break block71;
                                                                }
                                                                catch (Exception var7_8) {
                                                                    if (!(var7_8 instanceof IOException)) {
                                                                        var7_8.printStackTrace();
                                                                    }
                                                                    if (this.mDownload.getStatus() == 7) {
                                                                        this.mDownload.setStatus(8);
                                                                        this.mDownload.setStoppingTime(System.currentTimeMillis());
                                                                    } else if (this.mDownload.getStatus() != 9) {
                                                                        this.mDownload.setStatus(5, var7_8.getMessage());
                                                                        this.mDownload.setStoppingTime(System.currentTimeMillis());
                                                                        this.mDownload.appendLog("Error: ".concat(String.valueOf(String.valueOf(var7_8))));
                                                                    }
                                                                    if (this.mHost == null) {
                                                                        this.mDownload.removeCurrentCandidate();
                                                                    }
                                                                    var27_27 = null;
                                                                    this.mManager.decDownloadingCount();
                                                                    if (this.mHost != null) {
                                                                        this.mHost.disconnect();
                                                                        this.mHost = null;
                                                                    }
                                                                    if (var3_3 != null) {
                                                                        try {
                                                                            var3_3.close();
                                                                        }
                                                                        catch (IOException var28_28) {
                                                                            // empty catch block
                                                                        }
                                                                        if (this.mDownload.getStatus() == 4) {
                                                                            new File(var6_6).renameTo(new File(var5_5));
                                                                            this.mDownload.appendLog(String.valueOf(String.valueOf(new StringBuffer("Rename '").append(var6_6).append("' to '").append(var5_5).append("'"))));
                                                                        }
                                                                    }
                                                                    var3_3 = null;
                                                                    var28_28 = new File(this.mDownload.getDownloadName());
                                                                    if (var28_28.exists() && this.mDownload.getStatus() == 9) {
                                                                        var28_28.delete();
                                                                    }
                                                                    this.mDownload.setDownloadWorker(null);
                                                                    this.mDownload = null;
                                                                    continue;
                                                                }
                                                            }
                                                            catch (Throwable var26_30) {
                                                                block73: {
                                                                    block74: {
                                                                        var27_27 = null;
                                                                        this.mManager.decDownloadingCount();
                                                                        if (this.mHost != null) {
                                                                            this.mHost.disconnect();
                                                                            this.mHost = null;
                                                                        }
                                                                        if (var3_3 == null) break block73;
                                                                        ** try [egrp 6[TRYBLOCK] [6 : 1658->1665)] { 
lbl220:
                                                                        // 1 sources

                                                                        var3_3.close();
                                                                        break block74;
lbl222:
                                                                        // 1 sources

                                                                        catch (IOException var28_28) {
                                                                            // empty catch block
                                                                        }
                                                                    }
                                                                    if (this.mDownload.getStatus() == 4) {
                                                                        new File(var6_6).renameTo(new File(var5_5));
                                                                        this.mDownload.appendLog(String.valueOf(String.valueOf(new StringBuffer("Rename '").append(var6_6).append("' to '").append(var5_5).append("'"))));
                                                                    }
                                                                }
                                                                var3_3 = null;
                                                                var28_28 = new File(this.mDownload.getDownloadName());
                                                                if (var28_28.exists() && this.mDownload.getStatus() == 9) {
                                                                    var28_28.delete();
                                                                }
                                                                this.mDownload.setDownloadWorker(null);
                                                                this.mDownload = null;
                                                                throw var26_30;
                                                            }
                                                        }
                                                        ** try [egrp 6[TRYBLOCK] [6 : 1658->1665)] { 
lbl240:
                                                        // 1 sources

                                                        var3_3.close();
                                                        break block75;
lbl242:
                                                        // 1 sources

                                                        catch (IOException var28_28) {
                                                            // empty catch block
                                                        }
                                                    }
                                                    if (this.mDownload.getStatus() == 4) {
                                                        new File(var6_6).renameTo(new File(var5_5));
                                                        this.mDownload.appendLog(String.valueOf(String.valueOf(new StringBuffer("Rename '").append(var6_6).append("' to '").append(var5_5).append("'"))));
                                                    }
                                                }
                                                var3_3 = null;
                                                var28_28 = new File(this.mDownload.getDownloadName());
                                                if (var28_28.exists() && this.mDownload.getStatus() == 9) {
                                                    var28_28.delete();
                                                }
                                                this.mDownload.setDownloadWorker(null);
                                                this.mDownload = null;
                                                continue;
                                            }
                                            var27_27 = null;
                                            this.mManager.decDownloadingCount();
                                            if (this.mHost != null) {
                                                this.mHost.disconnect();
                                                this.mHost = null;
                                            }
                                            if (var3_3 == null) break block76;
                                            ** try [egrp 6[TRYBLOCK] [6 : 1658->1665)] { 
lbl266:
                                            // 1 sources

                                            var3_3.close();
                                            break block77;
lbl268:
                                            // 1 sources

                                            catch (IOException var28_28) {
                                                // empty catch block
                                            }
                                        }
                                        if (this.mDownload.getStatus() == 4) {
                                            new File(var6_6).renameTo(new File(var5_5));
                                            this.mDownload.appendLog(String.valueOf(String.valueOf(new StringBuffer("Rename '").append(var6_6).append("' to '").append(var5_5).append("'"))));
                                        }
                                    }
                                    var3_3 = null;
                                    var28_28 = new File(this.mDownload.getDownloadName());
                                    if (var28_28.exists() && this.mDownload.getStatus() == 9) {
                                        var28_28.delete();
                                    }
                                    this.mDownload.setDownloadWorker(null);
                                    this.mDownload = null;
                                    continue;
                                }
                                var27_27 = null;
                                this.mManager.decDownloadingCount();
                                if (this.mHost != null) {
                                    this.mHost.disconnect();
                                    this.mHost = null;
                                }
                                if (var3_3 == null) break block78;
                                ** try [egrp 6[TRYBLOCK] [6 : 1658->1665)] { 
lbl292:
                                // 1 sources

                                var3_3.close();
                                break block79;
lbl294:
                                // 1 sources

                                catch (IOException var28_28) {
                                    // empty catch block
                                }
                            }
                            if (this.mDownload.getStatus() == 4) {
                                new File(var6_6).renameTo(new File(var5_5));
                                this.mDownload.appendLog(String.valueOf(String.valueOf(new StringBuffer("Rename '").append(var6_6).append("' to '").append(var5_5).append("'"))));
                            }
                        }
                        var3_3 = null;
                        var28_28 = new File(this.mDownload.getDownloadName());
                        if (var28_28.exists() && this.mDownload.getStatus() == 9) {
                            var28_28.delete();
                        }
                        this.mDownload.setDownloadWorker(null);
                        this.mDownload = null;
                        continue;
                    }
                    var27_27 = null;
                    this.mManager.decDownloadingCount();
                    if (this.mHost != null) {
                        this.mHost.disconnect();
                        this.mHost = null;
                    }
                    if (var3_3 == null) break block80;
                    ** try [egrp 6[TRYBLOCK] [6 : 1658->1665)] { 
lbl318:
                    // 1 sources

                    var3_3.close();
                    break block81;
lbl320:
                    // 1 sources

                    catch (IOException var28_28) {
                        // empty catch block
                    }
                }
                if (this.mDownload.getStatus() == 4) {
                    new File(var6_6).renameTo(new File(var5_5));
                    this.mDownload.appendLog(String.valueOf(String.valueOf(new StringBuffer("Rename '").append(var6_6).append("' to '").append(var5_5).append("'"))));
                }
            }
            var3_3 = null;
            var28_28 = new File(this.mDownload.getDownloadName());
            if (var28_28.exists() && this.mDownload.getStatus() == 9) {
                var28_28.delete();
            }
            this.mDownload.setDownloadWorker(null);
            this.mDownload = null;
        }
    }

    private boolean deleteExistingFile(String string) throws Exception {
        File file = new File(string);
        if (file.exists()) {
            int n = JOptionPane.showConfirmDialog(ServiceManager.getManager().getMainFrame(), String.valueOf(String.valueOf(new StringBuffer("The file '").append(string).append("' exists already.  Overwrite it with the download file?"))), "Confirmation", 1, 1);
            if (n != 0) {
                return false;
            }
            if (!file.delete()) {
                String string2 = "Failed to delete the old file '";
                string2 = String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(string)).concat(".'"))));
                JOptionPane.showMessageDialog(ServiceManager.getManager().getMainFrame(), string2, "Failed To Delete File", 0);
                throw new Exception("Failed To Delete File");
            }
            this.mDownload.appendLog("Old file deleted.");
        }
        return true;
    }

    private boolean hasServerResumeSupport(String string) {
        int n;
        if (string == null) {
            return false;
        }
        int n2 = string.indexOf("LIMEWIRE");
        return n2 == -1 || (n = string.indexOf(".")) != -1;
    }
}

